// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef CDWriter_INCLUDED
#define CDWriter_INCLUDED

#include <qwidget.h>
#include <kprocess.h>

#include "ProcessInterface.h"

class CDTrack;
class ProgressDialog;
class PipeCopy;

class CDWriter : public ProcessInterface {
  Q_OBJECT;
 public:
  enum  Fixating {Fix_None,Fix_Session,Fix_CD};

  CDWriter (void);
  void    setupCD(int ntrack,CDTrack **track,bool simmode,int speed,Fixating fix,bool eject,bool onthefly);
  int    burnCD(void);
  long int    getCDFree(void);
  long int    getNeedSpace(void);
  bool freshCD(void);

  bool checkDiskSpace();
  bool checkMSMismatch();
  bool prepareBurn(ProgressDialog *prog);
  void cleanupBurn(void);

  static bool singleDrive(void);
    
 protected slots:
  void onTheFlyTerminated(ProcessInterface *pint,int retval);
  void pipeHasOutput(void);

 protected:
  int    callRecord(bool capread=false);
  virtual int       processExited(void);
  virtual bool    processStdoutLine(char *buffer);
  virtual bool    processStderrLine(char *buffer);
  virtual int  processCleanup(int rval);
  long int        getSize(CDTrack *trk);
  
 private:
  int burnstate,burntrack,burnsize,burnoffset;

  bool     getCapacity;
  long int blocksTotal;
  long int blocksFree;
  long int blocksRemain;
  int      numTracks;

  long int needSpace;
  
  CDTrack  *cdTracks[256];
  long int trackSize[256];
  long int blockSize[256];
  bool simMode;
  int writeSpeed;
  Fixating fixMode;
  bool ejectCD;
  bool onTheFly;  
  bool delayedStart;
  int flyTrack;
  long int currentTrack;
  long int trackOffset;
  PipeCopy *pipeCopy;
};

#endif
