// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#define SUN_MAGIC 0x2e736e64
#define DEC_MAGIC 0x2e736400
#define MIN_HDRSIZE 24

#define SUN_ULAW        1                       /* u-law encoding */
#define SUN_LIN_8       2                       /* Linear 8 bits */
#define SUN_LIN_16      3                       /* Linear 16 bits */
#define SUN_LIN_24      4                       /* Linear 24 bits */
#define SUN_LIN_32      5                       /* Linear 32 bits */
#define SUN_FLOAT       6                       /* IEEE FP 32 bits */
#define SUN_DOUBLE      7                       /* IEEE FP 64 bits */
#define SUN_G721        23                      /* CCITT G.721 4-bits ADPCM */
#define SUN_G723_3      25                      /* CCITT G.723 3-bits ADPCM */
#define SUN_G723_5      26                      /* CCITT G.723 5-bits ADPCM */
#define SUN_ALAW        27                      /* a-law encoding */


#include "AuIdentify.h"

int AuIdentify::identify(void) {
  long int auheader,auformat,auchannels,magic;
  long int aurate;
  long int datapos,datasize;

  resetFile();
  if (!readBELong(&magic))  return(0);
  if ( (magic!=SUN_MAGIC) && (magic!=DEC_MAGIC) ) return(0);
  if (!readBELong(&auheader)) return(0);
  if (auheader<MIN_HDRSIZE) return(0);
  if (!readBELong(&datasize)) return(0);
  if (!readBELong(&auformat)) return(0);
  if (!readBELong(&aurate)) return(0);
  if (!readBELong(&auchannels)) return(0);
  datapos=auheader;

  switch (auformat) {
  case SUN_LIN_8: 
  case SUN_LIN_16:
  case SUN_LIN_32:
    setSampleFormat(AudioIdentify::Samples_PCM);
    break;
  case SUN_ULAW:
    setSampleFormat(AudioIdentify::Samples_ULaw);
    break;
  case SUN_ALAW:
    setSampleFormat(AudioIdentify::Samples_ALaw);
    break;
  default:
    return(0);
  }

  switch (auformat) {
  case SUN_LIN_8:
  case SUN_ULAW:
  case SUN_ALAW:
    setSampleSize(AudioIdentify::Samples_8Bit);
    break;
  case SUN_LIN_16:
    setSampleSize(AudioIdentify::Samples_16Bit);
    break;
  case SUN_LIN_32:
    setSampleSize(AudioIdentify::Samples_32Bit);
    break;
  default:
    return(0);
  }

  setSampleEndian(AudioIdentify::Endian_Big);
  setSampleChannels(auchannels);
  setSampleRate(aurate);
  setDataPos(datapos);
  setDataSize(datasize);
  if ( (sampleChannels()<=0 ) || 
       (sampleRate()<=0) || (dataSize()==0)) {
    return(0);
  }
  setName("SUN AU format");
  return(1); 
}
