// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "MP3Converter.h"

bool MP3Converter::doConvert(const char *source,const char *dest) {
  *this<<PATH_MPG123<<"-v"<<"--cdr"<<dest<<source;
  firstCall=true;
  return(true);
}

bool MP3Converter::processStderrLine(char *linebuffer) {
  if (strCompare("Frame#",linebuffer,6)==0) {
    long int cFrame,rFrame;
    char *xptr,*yptr;
    long int val;
    xptr=linebuffer+6;
    if (*xptr=='\0') return(true);
    while ( *xptr==' ') ++xptr;
    val=strToLong(xptr,&yptr,10);
    cFrame=val;
    if (yptr==xptr) return(true);
    xptr=yptr;
    while ( *xptr==' ') ++xptr;
    if (*xptr++!='[') return (true);
    while ( *xptr==' ') ++xptr;
    val=strToLong(xptr,&yptr,10);
    rFrame=val;
    if (yptr==xptr) return(true);
    xptr=yptr;
    while (*xptr==' ') ++xptr;
    if (*xptr!=']') return(true);
    if (firstCall) {
      startTrack(cFrame+rFrame);
      firstCall=false;
    }
    setPosition(cFrame);
  }
 
  if (linebuffer[0]=='[') {
    char *xptr=linebuffer;
    while ( (*xptr!=0) && (*xptr++!=']') );
    if (*xptr==0) return(true);
    if (strCompare(xptr," Decoding of",12)==0) convflag=1;
  } 
  return(true);
}
