/***************************************************************************
                          fileoperation.cpp  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <klocale.h>
#include <kio/netaccess.h>
#include <kio/job.h>

// QT includes
#if QT_VERSION >= 0x030100
    #include <qeventloop.h>
#else
    #include <qapplication.h>
#endif

#include <qfileinfo.h>

// OS includes
#include <stdio.h>
#include <unistd.h>

// Own includes
#include "fileoperation.h"
#include "ProgressDialog.h"
#include "batchrenamer.h"

using namespace KIO;

FileOperation::FileOperation()
{
    canceled = false;
}

FileOperation::~FileOperation() { }

bool FileOperation::start( const KURL & src, const KURL & dest, int mode, bool overwrite )
{
    locked = true;
    result = 0;

    if( src == dest && !overwrite ) {
        m_error = QString( i18n( "File %1 exists already!") ).arg( dest.prettyURL() );
        return false;
    }
    
    Job* job = 0;
    switch( mode ) {
        case RENAME:
        case MOVE:
        default:
            job = file_move( src, dest, -1, overwrite, false, false ); 
            break;
        case COPY:
            job = file_copy( src, dest, -1, overwrite, false, false ); 
            break;
        case LINK:
            // Does only work if both files are on the same host
            if( src.protocol() == dest.protocol() && src.host() == dest.host() )
            {
                job = symlink( src.path(), dest, overwrite, false );
            }
            else
            {
                m_error = i18n("Can't create symlinks on different hosts for file %1.").arg( src.prettyURL() );
                result = true;
                return !result;
            }
            break;
    };

    if( !job )
        return false;
        
    job->setAutoErrorHandlingEnabled( false, 0 );
    connect( job, SIGNAL( result (KIO::Job *) ),
           this, SLOT( slotResult (KIO::Job *) ) );

#if QT_VERSION >= 0x030100
    kapp->eventLoop()->enterLoop();
#else
    kapp->enter_loop();
#endif
    return !result;
}

bool FileOperation::fcopy( const QString & src, const QString & dest )
{
    return start( KURL( src ), KURL( dest ), KIO::CopyJob::Copy, false );
}

QString FileOperation::getName( const QString & file )
{
    QFileInfo info( file );
    return info.fileName();
}

void FileOperation::slotResult( KIO::Job * job )
{
    result = job->error();
    if( result )
        m_error = job->errorString();

#if QT_VERSION >= 0x030100
    kapp->eventLoop()->exitLoop();
#else
    kapp->exit_loop();
#endif
}

