/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef PORTNUMBERNAMELIST_H
#define PORTNUMBERNAMELIST_H

#define TCP_TYPE 1
#define UDP_TYPE 2
#define DDP_TYPE 4

#include <netinet/in.h>

#include <qstring.h>
#include <qmap.h>

/**
@author Giovanni Venturi
*/

class PortNumberName
{
  public:
    PortNumberName() : m_protocolType( 0 ) {}
    PortNumberName( QString portName ) : m_name( portName ), m_protocolType( 0 ) {}

    QString name() const { return m_name; }
    short protocolType() const { return m_protocolType; }
    void addTCPState() { m_protocolType |= TCP_TYPE; }
    void addUDPState() { m_protocolType |= UDP_TYPE; }
    void addDPPState() { m_protocolType |= DDP_TYPE; }

  private:
    QString m_name;
    short m_protocolType;  // TCP_NUM: 1 -> tcp, UDP_NUM: 2 -> udp, DDP_NUM: 4 -> ddp
};

class PortNumberNameList
{
  public:
    PortNumberNameList();

    QString detectPortNumberName( uint16_t const& proto );
    bool isTCP( uint16_t const& protoNum );
    bool isUDP( uint16_t const& protoNum );
    bool isDDP( uint16_t const& protoNum );

  private:
    QMap<uint16_t, PortNumberName> m_portNumber;
};

#endif
