/***************************************************************************
 *   Copyright (C) 2005 by Will Entriken                                   *
 *   william.entriken@villanova.edu                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "processlistviewitem.h"

#include "processlistviewitem.h"
#include "processcontroller.h"

ProcessListViewItem::ProcessListViewItem( QListView * parent )
  : QListViewItem(parent), myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::ProcessListViewItem( QListViewItem * parent )
  : QListViewItem(parent), myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::ProcessListViewItem( QListView * parent, QListViewItem * after )
  : QListViewItem(parent, after), myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::ProcessListViewItem( QListViewItem * parent, QListViewItem * after )
  : QListViewItem(parent, after), myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::ProcessListViewItem( QListView * parent,
			      QString label1,
			      QString label2,
			      QString label3,
			      QString label4,
			      QString label5,
			      QString label6,
			      QString label7,
			      QString label8 )
  : QListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8), myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::ProcessListViewItem( QListViewItem * parent,
			      QString label1,
			      QString label2,
			      QString label3,
			      QString label4,
			      QString label5,
			      QString label6,
			      QString label7,
			      QString label8 )
  : QListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8), myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::ProcessListViewItem( QListView * parent, QListViewItem * after,
			      QString label1,
			      QString label2,
			      QString label3,
			      QString label4,
			      QString label5,
			      QString label6,
			      QString label7,
			      QString label8 )
  : QListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8), 
    myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::ProcessListViewItem( QListViewItem * parent, QListViewItem * after,
			QString label1,
			QString label2,
			QString label3,
			QString label4,
			QString label5,
			QString label6,
			QString label7,
			QString label8 )
  : QListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8), 
    myProcessController(new ProcessController(this))
{
}

ProcessListViewItem::~ProcessListViewItem()
{
}

ProcessController * ProcessListViewItem::getProcessController()
{
	return myProcessController;
}
