/***************************************************************************
 *   Copyright (C) 2005-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ktradddictionarywizard.h"

#include <qlineedit.h>
#include <qbuttongroup.h>

#include <kurlrequester.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif


KtrAddDictionaryWizard::KtrAddDictionaryWizard()
{
  setFinishEnabled( WizardPage_5, true );
  connect( this, SIGNAL( selected( const QString & ) ), this, SLOT( pageSelected( const QString & ) ) );
}

KtrAddDictionaryWizard::~KtrAddDictionaryWizard()
{
}


QString KtrAddDictionaryWizard::dicName()
{
  return nameEdit->text();
}


QString KtrAddDictionaryWizard::dicPlugin()
{
  int pluginId = pluginGroup->selectedId();
  if( pluginId == 0 ) return "ktranslator_plaintext";
  else if( pluginId == 1 ) return "ktranslator_dictd";
  else if( pluginId == 2 ) return "ktranslator_babylon";
  else if( pluginId == 3 ) return "ktranslator_stardict";
  else return "ktranslator_sdict";
}


QString KtrAddDictionaryWizard::dicFile()
{
  return fileRequester->url();
}


void KtrAddDictionaryWizard::setDicName( const QString &name )
{
  nameEdit->setText( name );
}


void KtrAddDictionaryWizard::setDicFile( const QString &file )
{
  fileRequester->setURL( file );
}


void KtrAddDictionaryWizard::setDicPlugin( const QString &plugin )
{
  int pluginId ;
  if( plugin == "ktranslator_plaintext" ) pluginId = 0;
  else if( plugin == "ktranslator_dictd" ) pluginId = 1;
  else if( plugin == "ktranslator_babylon" ) pluginId = 2;
  else if( plugin == "ktranslator_stardict" ) pluginId = 3;
  else pluginId = 4;// "ktranslator_sdict"
  pluginGroup->setButton( pluginId );
}


void KtrAddDictionaryWizard::pageSelected( const QString &name )
{
  /*#ifndef NDEBUG

    kdDebug() << "Page: " << name << endl;

  #endif*/
  if( name == "Dictionary File" )
  {
    int pluginId = pluginGroup->selectedId();
    if( pluginId == -1 ) return;
    else if( pluginId == 0 ) fileRequester->setFilter( "*.dic|Plain Text files" );
    else if( pluginId == 1 ) fileRequester->setFilter( "*.index|Index DICT files" );
    else if( pluginId == 2 ) fileRequester->setFilter( "*.dic|Babylon Dictionary files" );
    else if( pluginId == 3 ) fileRequester->setFilter( "*.ifo|StarDict Dictionary files" );
    else if( pluginId == 4 ) fileRequester->setFilter( "*.dct|Sdictionary Dictionary files" );
  }
}

#include "ktradddictionarywizard.moc"
