/***************************************************************************
                          weatherlib.cpp  -  description
                             -------------------
    begin                : Wed Jul 5 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "weatherlib.h"
#include <iostream.h>
#include <klocale.h>
#include <qdatetime.h>

weatherlib::weatherlib()
{
  WindRegExp1 = QRegExp("00000KT", TRUE, FALSE);
  /** Wind with Gusts */
  WindRegExp2 = QRegExp("[0-9][0-9][0-9][0-9][0-9]G[0-9][0-9]KT", TRUE, FALSE);
  /** Steady Wind */
  WindRegExp3 		= QRegExp("^[0-9][0-9][0-9][0-9][0-9]KT", TRUE, FALSE);
  VisRegExp1 			= QRegExp("^[0-9][0-9]SM", TRUE, FALSE);
	VisRegExp2 			= QRegExp("^[0-9]SM", TRUE, FALSE);
  TempRegExp1 		= QRegExp("^[0-9][0-9]/[0-9][0-9]", TRUE, FALSE);
  TempRegExp2 		= QRegExp("^[0-9][0-9]/M[0-9][0-9]", TRUE, FALSE);
  TempRegExp3 		= QRegExp("^M[0-9][0-9]/[0-9][0-9]", TRUE, FALSE);
  TempRegExp4 		= QRegExp("^M[0-9][0-9]/M[0-9][0-9]", TRUE, FALSE);
	CoverRegExp1 		= QRegExp("^FEW[0-9][0-9][0-9]", TRUE, FALSE);
	CoverRegExp2 		= QRegExp("^SCT[0-9][0-9][0-9]", TRUE, FALSE);
	CoverRegExp3 		= QRegExp("^BKN[0-9][0-9][0-9]", TRUE, FALSE);
	CoverRegExp4 		= QRegExp("^OVC[0-9][0-9][0-9]", TRUE, FALSE);
	CoverRegExp5 		= QRegExp("^SCK?CLR?", TRUE, FALSE);
	CoverRegExp6		=	QRegExp("^VV[0-9][0-9][0-9]", TRUE, FALSE);
  CurrentRegExp1 	= QRegExp("+[A-Z][A-Z][A-Z]?[A-Z]?", TRUE, FALSE);
	CurrentRegExp2 	= QRegExp("-[A-Z][A-Z][A-Z]?[A-Z]?", TRUE, FALSE);
	CurrentRegExp3 	= QRegExp("^[A-Z][A-Z][A-Z]?[A-Z]?", TRUE, FALSE);
	TimeRegExp1 		= QRegExp("^[0-9][0-9][0-9][0-9][0-9][0-9]Z", TRUE, FALSE);
  DateRegExp1			= QRegExp("^[0-9][0-9][0-9][0-9]/[0-1][0-2]/[0-3][0-9]", TRUE, FALSE);
	PressRegExp1		=	QRegExp("^A[0-9][0-9][0-9]?[0-9]?", true, false);
	PressRegExp2		=	QRegExp("^Q[0-9][0-9][0-9]?[0-9]?", true, false);
}
weatherlib::~weatherlib(){
}
/** Parse the current cover type */
void weatherlib::parseCover( QString s){
   QString skycondition = "";
   if (s.contains( CoverRegExp1 ) == 1)
  	{
			skycondition = I18N_NOOP(" Few Clouds");
			skycondition += I18N_NOOP(" at ");
            QString height = s.mid(3,3);
            height.replace(QRegExp("^0+"), "");
			skycondition += height;
			skycondition += I18N_NOOP(" thousand feet");
  		if (!weatherGood)
				clouds += 2;
		}
	 else if (s.contains( CoverRegExp2 ) == 1)
  	{
	 		skycondition = I18N_NOOP(" Scattered Clouds");
			skycondition += I18N_NOOP(" at ");
            QString height = s.mid(3,3);
            height.replace(QRegExp("^0+"), "");
			skycondition += height;
			skycondition += I18N_NOOP(" thousand feet");
			if (!weatherGood)
				clouds += 4;
		}
	 else if (s.contains( CoverRegExp3 ) == 1)
  	{
	 		skycondition = I18N_NOOP(" Broken Clouds");
			skycondition += I18N_NOOP(" at ");
            QString height = s.mid(3,3);
            height.replace(QRegExp("^0+"), "");
			skycondition += height;
			skycondition += I18N_NOOP(" thousand feet");
			if (!weatherGood)
				clouds += 8;
		}
	 else if (s.contains( CoverRegExp4 ) == 1)
  	{
	 		skycondition = I18N_NOOP(" Overcast Clouds");
			skycondition += I18N_NOOP(" at ");
            QString height = s.mid(3,3);
            height.replace(QRegExp("^0+"), "");
			skycondition += height;
			skycondition += I18N_NOOP(" thousand feet");
			if (!weatherGood)
				clouds += 16;
		}
	 else if (s.contains( CoverRegExp5 ) == 1)
   {
			skycondition = I18N_NOOP("No clouds");
  		if (!weatherGood)
				clouds += 0;
		}
		else if (s.contains( CoverRegExp6 ) == 1)
		{
     		skycondition = I18N_NOOP("Overcast clouds");
				if (!weatherGood)
						clouds = 16;
		}
	qsCover += skycondition;
		//cerr<< "Current Skycondition " << qsCover << endl;
	  //cerr<< "Data: " << s << endl;
}

/** Parse the current weather conditions */
void weatherlib::parseCurrent(QString s){
	QString currentWeather = "";
	bool good = false;
   if (s.contains( CurrentRegExp2 ) == 1)
   {
			currentWeather = I18N_NOOP("Light");
			good = true;
   }
	else if (s.contains( CurrentRegExp1 ) == 1)
	{
			currentWeather = I18N_NOOP("Heavy");
			good = true;
	}
  else if (s.contains( CurrentRegExp3 ) == 1)
	{
			good = true;
  		currentWeather = "";
	}
	if ( s.contains( "MI" ) == 1 && good )
			currentWeather += I18N_NOOP(" Shallow");
	if ( s.contains( "PR" ) == 1 && good )
			currentWeather += I18N_NOOP(" Partial");
	if ( s.contains( "BC" ) == 1 && good )
			currentWeather += I18N_NOOP(" Patches");
	if ( s.contains( "DR" ) == 1 && good )
			currentWeather += I18N_NOOP(" Low Drifting");
	if ( s.contains( "BL" ) == 1 && good )
			currentWeather += I18N_NOOP(" Blowing");
	if ( s.contains( "SH" ) == 1 && good )
			currentWeather += I18N_NOOP(" Showers");
	if ( s.contains( "TS" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Thunder Storm");
			if ( clouds > 0 && clouds <= 10)
					theWeather = "tstorm1";
			else if ( clouds > 10 && clouds <= 20)
					theWeather = "tstorm2";
			else if ( clouds > 20)
					theWeather = "tstorm3";
			weatherGood = true;
	}
	if ( s.contains( "FZ" ) == 1 && good )
			currentWeather += I18N_NOOP(" Freezing");
	if ( s.contains( "DZ" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Drizzle");
			theWeather = "light_rain";
			weatherGood = true;
	}
	if ( s.contains( "RA" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Rain");
			if ( clouds >= 0 && clouds <= 10)
					theWeather = "shower1";
			else if ( clouds > 10 && clouds <= 20)
					theWeather = "shower2";
			else
					theWeather = "shower3";
			weatherGood = true;
	}
	if ( s.contains( "SN" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Snow");
			if ( clouds >= 0 && clouds <= 8)
					theWeather = "snow1";
			else if ( clouds > 8 && clouds <= 16)
					theWeather = "snow2";
			else if ( clouds > 16 && clouds <= 24)
					theWeather = "snow3";
			else
					theWeather = "snow5";
			weatherGood = true;
	}
	if ( s.contains( "SG" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Snow Grains");
			theWeather = "snow4";
			weatherGood = true;
	}
	if ( s.contains( "IC" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Ice Crystals");
			theWeather = "hail";
			weatherGood = true;
	}
	if ( s.contains( "PE" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Ice Pellets");
			theWeather = "hail";
			weatherGood = true;
	}
	if ( s.contains( "GR" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Hail");
			theWeather = "hail";
			weatherGood = true;
	}
	if ( s.contains( "GS" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Small Hail Pellets");
			theWeather = "hail";
			weatherGood = true;
	}
	if ( s.contains( "UP" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Unknown Precipitation");
			theWeather = "dunno";
	}
	if ( s.contains( "BR" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Mist");
			theWeather = "mist";
			weatherGood = true;
	}
	if ( s.contains( "FG" ) == 1 && good )
	{
			currentWeather += I18N_NOOP(" Fog");
			theWeather = "fog";
			weatherGood = true;
	}
	if ( s.contains( "FU" ) == 1 && good )
			currentWeather += I18N_NOOP(" Smoke");
	if ( s.contains( "VA" ) == 1 && good )
			currentWeather += I18N_NOOP(" Volcanic Ash");
	if ( s.contains( "DU" ) == 1 && good )
			currentWeather += I18N_NOOP(" Widespread Dust");
	if ( s.contains( "SA" ) == 1 && good )
			currentWeather += I18N_NOOP(" Sand");
	if ( s.contains( "HZ" ) == 1 && good )
			currentWeather += I18N_NOOP(" Haze");
	if ( s.contains( "PY" ) == 1 && good )
			currentWeather += I18N_NOOP(" Spray");
	if ( s.contains( "PO" ) == 1 && good )
			currentWeather += I18N_NOOP(" Well Developed \n Dust Swirls");
	if ( s.contains( "SQ" ) == 1 && good )
			currentWeather += I18N_NOOP(" Squall");
	if ( s.contains( "FC" ) == 1 && good )
			currentWeather += I18N_NOOP(" Funnel Cloud");
	if ( s.contains( "SS" ) == 1 && good )
			currentWeather += I18N_NOOP(" Sand Storm");
  if (good)
	{
		qsCurrent = currentWeather;
		//cerr<< "Current Weather " << qsCurrent << endl;
	  //cerr<< "Data: " << s << endl;
	}
}
/** Parse out the current date. */
void weatherlib::parseDate(QString s){
	//cerr << "Do date" << s << endl;
	if (s.contains( DateRegExp1 ) == 1)
	{
		//cerr << "Got it" << endl;
		qsDate = s;
	}	
}
/** Parse out the current temperature */
void weatherlib::parseTemperature(QString s){
	float temperature = 0.0;
	float dewpoint = 0.0;
  bool good = false;
   if (s.contains( TempRegExp1 ) == 1)
   {
      	QString subStr = s.mid(0,2);
      	temperature = subStr.toFloat();
				subStr = s.mid(3,2);
				dewpoint = subStr.toFloat();
				good = true;
   }
   else if (s.contains( TempRegExp2) == 1)
   {
        QString subStr = s.mid(0,2);
      	temperature = subStr.toFloat();
				subStr = s.mid(4,2);
        dewpoint = subStr.toFloat();
        //if ( s.mid(3,1) == "M")
            dewpoint = dewpoint * -1;
				good = true;
   }
   else if (s.contains( TempRegExp3) == 1)
   {
        QString subStr = s.mid(1,2);
      	temperature = subStr.toFloat();
				subStr = s.mid(4,2);
        dewpoint = subStr.toFloat();
        //if ( s.mid(0,1) == "M")
            temperature = temperature * -1;
				good = true;
   }
   else if (s.contains( TempRegExp4) == 1)
   {
        QString subStr = s.mid(1,2);
      	temperature = subStr.toFloat();
				subStr = s.mid(5,2);
        dewpoint = subStr.toFloat();
        //if ( s.mid(0,1) == "M")
        temperature = temperature * -1;
        //if ( s.mid(4,1) == "M")
        dewpoint = dewpoint * -1;
				good = true;
  }
   if (good)
		{
		if (MetricMode)
			{
       	qsTemperature.setNum(temperature);
  			qsTemperature += "C";
  		}
  		else
  		{
       	qsTemperature.setNum((temperature* 9 / 5) + 32);
  			qsTemperature += "F";
  		}	
		}
}
/** Parse out the current time. */
void weatherlib::parseTime(QString s){
	QString qsHours;
	QString qsMin;
	if (s.contains( TimeRegExp1 ) == 1)	
	{
		qsHours = s.mid(2,2);
		qsMin = s.mid(4,2);
		qsTime = qsHours + ":" + qsMin;
		//cerr<< qsHours << ":" << qsMin << endl;	
	}
}
/** Parse out the current visability */
void weatherlib::parseVisability( QString s){
	float visability = 0.0;
	bool good = false;
	if (s.contains( VisRegExp1 ) == 1)
	{
   	QString subStr = s.left(s.length() - 2);
   	visability = subStr.toFloat();
		good = true;
	}
	else if ( s.contains( VisRegExp2) == 1)
	{
   	QString subStr = s.left(s.length() - 2);
   	visability = subStr.toFloat();
		good = true;
	}
	if (good)
	{
		if (MetricMode)
		{
    	visability = visability * 1.6;
			qsVisability.setNum(visability);
			qsVisability += "KM";
		}
		else
		{
     	qsVisability.setNum(visability);
			qsVisability += "M";
		}	
	}
}
/** Parse out the current pressure. */
void weatherlib::parsePressure( QString s){
	float pressure;
	if (s.contains( PressRegExp1 ) == 1)
	{
  		qsPressure = s.mid(1,4);
			pressure = (qsPressure.toFloat())/100;
			//cerr<< "Pressure:" << pressure << endl;
  	if (MetricMode)
  	{
    	qsPressure.setNum( pressure/0.29 );
  		qsPressure += "kP";	
  	}
  	else
  	{
    	qsPressure.setNum( pressure );
  		qsPressure += "\"Hg";
  	}	
	}
	else if (s.contains( PressRegExp2) == 1)
	{
  		qsPressure = s.mid(1,4);
			pressure = (qsPressure.toFloat())/100;
			//cerr<< "Pressure:" << pressure << endl;
  	if (!MetricMode)
  	{
    	qsPressure.setNum( pressure*0.29 );
  		qsPressure += "\"Hg";	
  	}
  	else
  	{
    	qsPressure.setNum( pressure / 10 );
  		qsPressure += "kPa";
  	}	
	}
}
/** Parse the wind speed */
void weatherlib::parseWindSpeed( QString s){
  float windSpeed = 0.0;
	float gustSpeed = 0.0;
	int windDir = 0;
	bool good = false;
	if (s.contains( WindRegExp1 ) == 1)
	{
		windSpeed = 0.0;
		gustSpeed = 0.0;
		windDir = 0;
		good = true;
	}
	else if ( s.contains( WindRegExp2 ) == 1)
	{
		QString subStr = s.mid(6, 2);
   	windSpeed = subStr.toFloat();
		subStr = s.mid(0,3);
		windDir = subStr.toInt();
		subStr = s.mid(3,2);
		good = true;
	}
	else if ( s.contains( WindRegExp3 ) == 1)
	{
		QString subStr = s.mid(3, 2);
   	windSpeed = subStr.toFloat();
		subStr = s.mid(0,3);
		windDir = subStr.toInt();
		gustSpeed = 0;
		good = true;
	}
	if (good)
	{
    	if (MetricMode)
    	{
    		windSpeed = (int) (windSpeed * 3.6/1.94);
    		qsWindSpeed.setNum(windSpeed);
    		//qsWindSpeed += "KPH";
    	}
    	else
    	{
      	windSpeed =(int) (windSpeed * 2.24/1.94);
    		qsWindSpeed.setNum(windSpeed);
    		//qsWindSpeed += "MPH";
    	}

    	// Take care of the wind directions...
      //		N   		E	- 338-22  W - 156-203
      // NW | NE    NE- 23-68  	SW- 204-248
      //W--`+'--E   N - 69-112  S - 249-294
      // SW'|`SE    NW- 113-157 SE- 295-337
      //    S
      if ((windDir >=0 && windDir < 23) || ( windDir >= 239 && windDir <= 360))
      		qsWindDirection = "E";
      else if ((windDir >=23 && windDir < 69))
      		qsWindDirection = "NE";
      else if ((windDir >=69 && windDir < 113))
      		qsWindDirection = "N";
      else if ((windDir >=113 && windDir < 157))
      		qsWindDirection = "NW";
      else if ((windDir >=157 && windDir < 203))
      		qsWindDirection = "W";
      else if ((windDir >=203 && windDir < 248))
      		qsWindDirection = "SW";
      else if ((windDir >=248 && windDir < 294))
      		qsWindDirection = "S";
      else if ((windDir >=294 && windDir < 238))
      		qsWindDirection = "SE";
	}
}

/** This is will tokenize the data and process it. */
void weatherlib::processData(QString newData, bool mode){
	//kdDebug() << "Processing data: " << newData << endl;
        weatherGood = false;
	clouds = 0;
	qsCover = "";
	qsCurrent = "";
	qsWindDirection = "";
	qsTime = "";
	qsTemperature = "";
	theWeather = "";
	qsWindSpeed = "";
	qsDate = "";
	qsPressure = "";
	qsVisability = "";
  QList<QString> dataList;
  QString tempData;
  uint i = 0;
	MetricMode = mode;
  newData.simplifyWhiteSpace();
  while( i < newData.length())
  {
  	if( (newData.at(i)) != ' ')
  		tempData += newData.at(i);
  	else
		{
			dataList.append( new QString(tempData) );
			tempData = "";
		}
  	i++;
  }
	bool flag = false;
	weatherGood = false;
	for ( i =0; i < dataList.count(); i++)
	{
		if ( *dataList.at(i) == "RMK")
				flag = true;
		if ( !flag )
 		{
			parseWindSpeed(*dataList.at(i));
			parseVisability(*dataList.at(i));
			parseTemperature(*dataList.at(i));
			parseCurrent(*dataList.at(i));
			parseCover(*dataList.at(i));
			parseTime(*dataList.at(i));
			parseDate(*dataList.at(i));
			parsePressure(*dataList.at(i));
		}
	}
}
/** Will return the current airpressure */
QString weatherlib::getPressure(){
	return qsPressure;	
}
/** Will return the wind data  as a QString */
QString weatherlib::getWindData(){
	return (qsWindSpeed + " " + qsWindDirection);
}
/**  */
QString weatherlib::getTemp(){
	return qsTemperature;
}
/** This will reuturn the index of the current ICON that should be displayed for the user. */
QString weatherlib::getCurrent(){
	if (!weatherGood)
	{
		if (clouds == 0)
			theWeather = "sunny";
		else if ( clouds > 0 && clouds <= 4)
			theWeather = "cloudy1";
		else if ( clouds > 4 && clouds <= 8)
			theWeather = "cloudy2";
		else if ( clouds > 8 && clouds <= 16)
			theWeather = "cloudy3";
		else if ( clouds > 16 )
			theWeather = "cloudy4";
	}
        //kdDebug() << "I want icon " << theWeather << " and clouds are at " << clouds << endl;
	return theWeather;
}
/** Returns the date of the weather data */
QString weatherlib::getDate(int GMT_Offset){
	// The Date should be in format YYYY/MM/DD
	// The Time should be in format HHMMz
	QString day, month, year, hour, minute = "";
	day = qsDate.mid(8,2);
	month = qsDate.mid(5,2);
	year = qsDate.mid(0,4);

	hour = qsTime.mid(0,2);
	minute = qsTime.mid(4,2);

	QDate theDate;
	QTime theTime;
	theTime.setHMS( hour.toInt(), minute.toInt(), 0);
	theDate.setYMD( year.toInt(), month.toInt(), day.toInt());	
	QDateTime returnTime( theDate, theTime);
	returnTime.addSecs(GMT_Offset *3600);

	return returnTime.toString();
	


}
/** return the current time of the sample... */
QString weatherlib::getTime(){
	return qsTime;
}
/**  */
QString weatherlib::getWeatherText(){
	QString theText = "Currently there are ";
	theText += qsCover + ".\n";
	if (qsCurrent != "")
		theText += "With " + qsCurrent + ".";
	return theText;
}
/** Returns the current cover */
QString weatherlib::getCover(){
	return qsCover;
}
/** return the visability */
QString weatherlib::getVisability(){
	return "";
}
/** return the weather text */
QString weatherlib::getCurrentText(){
 	return qsCurrent;
}
