//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef PIXMAPS_H
#define PIXMAPS_H

#include <qpixmap.h>
#include <qpainter.h>
#include <qimage.h>
#include <qcolor.h>

class Pixmaps
{
public:
	//static QPixmap *active_button_ground;
	//static QPixmap *inactive_button_ground;

	static QPixmap *active_help_normal;
	static QPixmap *active_max_normal;
	static QPixmap *active_min_normal;
	static QPixmap *active_close_normal;
	static QPixmap *active_sticky_normal;
	static QPixmap *active_above_normal;
	static QPixmap *active_below_normal;
	static QPixmap *active_menu_normal;

	static QPixmap *active_help_hover;
	static QPixmap *active_max_hover;
	static QPixmap *active_min_hover;
	static QPixmap *active_close_hover;
	static QPixmap *active_sticky_hover;
	static QPixmap *active_above_hover;
	static QPixmap *active_below_hover;
	static QPixmap *active_menu_hover;

	static QPixmap *active_help_sunken;
	static QPixmap *active_max_sunken;
	static QPixmap *active_min_sunken;
	static QPixmap *active_close_sunken;
	static QPixmap *active_sticky_sunken;
	static QPixmap *active_above_sunken;
	static QPixmap *active_below_sunken;
	static QPixmap *active_menu_sunken;

	static QPixmap *inactive_help_normal;
	static QPixmap *inactive_max_normal;
	static QPixmap *inactive_min_normal;
	static QPixmap *inactive_close_normal;
	static QPixmap *inactive_sticky_normal;
	static QPixmap *inactive_above_normal;
	static QPixmap *inactive_below_normal;
	static QPixmap *inactive_menu_normal;

	static QPixmap *inactive_help_hover;
	static QPixmap *inactive_max_hover;
	static QPixmap *inactive_min_hover;
	static QPixmap *inactive_close_hover;
	static QPixmap *inactive_sticky_hover;
	static QPixmap *inactive_above_hover;
	static QPixmap *inactive_below_hover;
	static QPixmap *inactive_menu_hover;

	static QPixmap *inactive_help_sunken;
	static QPixmap *inactive_max_sunken;
	static QPixmap *inactive_min_sunken;
	static QPixmap *inactive_close_sunken;
	static QPixmap *inactive_sticky_sunken;
	static QPixmap *inactive_above_sunken;
	static QPixmap *inactive_below_sunken;
	static QPixmap *inactive_menu_sunken;

	static bool pixmapsCreated;

	enum GradientDirections
	{
		HorizontalGradient =	1,
		VerticalGradient =	2
	};

	static void createPixmaps();
	static void deletePixmaps();

	static void unicity(int* pattern, QImage& work, int rr, int gg, int bb);

	static QColor colorMix(QColor backgroundColor, 
					QColor foregroundColor, 
					int alpha = 128);

	static void renderGradient(QPainter* p, 
					const QRect &r, 
					const QColor &c1, 
					const QColor &c2, 
					const int direction, 
					const bool convex = true);

	static void renderDiagonalGradient(QPainter* p, 
					const QRect &r, 
					const QColor &top, 
					const QColor &middle, 
					const QColor &bottom, 
					const bool convex = true);

	static void renderSquareGradient(QPainter* painter, 
					const QRect &rect, 
					const QColor &topleft, 
					const QColor &middle, 
					const QColor &bottomright, 
					const bool convex = true);

	static void renderSpecialCorner(QPainter* p, 
					const int x, 
					const int y, 
					const int size, 
					const QColor &top, 
					const QColor &middle, 
					const QColor &bottom);

	static void renderSurface(QPainter *p,
				 	QRect r,
				 	QColor backgroundColor,
				 	QColor surfaceColor,
				 	QColor highlightColor,
				 	uint flags = 0);

	static void renderFlatArea(QPainter* p,
				 	QRect r,
				 	QColor backgroundColor,
				 	QColor surfaceColor);

	static void renderSereneContour(QPainter* p,
					QRect r,
					QColor backgroundColor,
					QColor contour,
					uint flags);

	static void renderCarving(QPainter* p,
					QRect r,
					QColor backgroundColor,
					QColor contour);
};

#endif
