/***************************************************************************
                          actions.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "actions.h"

// include files for QT
#include <qlabel.h>
#include <qwhatsthis.h>
#include <qdragobject.h>
#include <qcombobox.h>

// include files for KDE
#include <ktoolbar.h>
#include <kmimetype.h>
#include <kdebug.h>

// application specific includes
#include "kxmleditor.h"

//-------------------------------------------------------------------
//
// KXmlEditorComboAction member functions
//
//-------------------------------------------------------------------

KXmlEditorComboAction::KXmlEditorComboAction(const QString& text,
                                             int accel,
                                             const QObject *receiver,
                                             const char *member,
                                             QObject* parent,
                                             const char* name)
    : KAction(text, accel, parent, name),
      m_pCombo(0)
{
	m_receiver = receiver;
  m_member = member;
}

KXmlEditorComboAction::~KXmlEditorComboAction()
{
	//delete m_pCombo; // L.V. this cause crash !!!
}

int KXmlEditorComboAction::plug(QWidget *w, int index)
{
  //  if ( !w->inherits( "KToolBar" ) );
  //    return -1;

  KToolBar *toolBar = (KToolBar *) w;

  int id = KAction::getToolButtonID();
  //kdDebug() << "KXmlEditorComboAction::plug id=" << id << endl;

  m_pCombo = new QComboBox( toolBar, "Path Combo" );
  m_pCombo->setEditable(true);
  m_pCombo->setInsertionPolicy(QComboBox::NoInsertion);
  toolBar->insertWidget( id, 70, m_pCombo, index );
  connect( m_pCombo, SIGNAL(activated(const QString&)), m_receiver, m_member );

  addContainer( toolBar, id );

  connect(toolBar, SIGNAL(destroyed()), this, SLOT(slotDestroyed()));

  toolBar->setItemAutoSized(id, true);

  QWhatsThis::add( m_pCombo, whatsThis() );

  return containerCount() - 1;
}

void KXmlEditorComboAction::unplug(QWidget *w)
{
//  if ( !w->inherits( "KToolBar" ) )
//    return;

  KToolBar *toolBar = (KToolBar *)w;

  int idx = findContainer( w );
  //kdDebug() << "KXmlEditorComboAction::unplug idx=" << idx << " menuId=" << menuId(idx) << endl;

  toolBar->removeItem( menuId( idx ) );

  removeContainer( idx );
  m_pCombo = 0;
}

void KXmlEditorComboAction::slotClear()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::slotClear] action not plugged" << endl;
    return;
  }

  m_pCombo->clear();
}

void KXmlEditorComboAction::slotClearEdit()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::slotClearEdit] action not plugged" << endl;
    return;
  }

  m_pCombo->clearEdit();
}

void KXmlEditorComboAction::slotFocusEdit()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::slotFocusEdit] action not plugged" << endl;
    return;
  }

  m_pCombo->setFocus();
}

QString KXmlEditorComboAction::currentText() const
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::currentText] action not plugged" << endl;
    return QString::null;
  }

  return m_pCombo->currentText();
}

const QPixmap * KXmlEditorComboAction::currentPixmap() const
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::currentPixmap] action not plugged" << endl;
    return 0;
  }

  return m_pCombo->pixmap( m_pCombo->currentItem() );
}

void KXmlEditorComboAction::insertItem( const QPixmap & pixmap, const QString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::insertItem] action not plugged" << endl;
    return;
  }

	if ( text.isEmpty() )
    kdWarning() << "[KXmlEditorComboAction::insertItem] empty string as parameter" << endl;

  int nIndex = findItem(text);
  if ( nIndex != -1 )
    m_pCombo->removeItem(nIndex);

  m_pCombo->insertItem( pixmap, text, 0 );
  m_pCombo->setCurrentItem(0);

  if ( m_pCombo->count() > 5 )
    m_pCombo->removeItem(5);
}

void KXmlEditorComboAction::removeItem( const QString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::removeItem] action not plugged" << endl;
    return;
  }

  int nIndex = findItem(text);
  if ( nIndex == -1 )
  {
    kdDebug() << "KXmlEditorComboAction::removeItem] item not found" << endl;
    return;
  }

  m_pCombo->removeItem(nIndex);
}

int KXmlEditorComboAction::findItem( const QString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KXmlEditorComboAction::findItem] action not plugged" << endl;
    return -1;
  }

  int nIndex = -1;
  int i=0;
  while ( ( i < m_pCombo->count() ) && ( nIndex == -1 ) )
  {
    if ( m_pCombo->text(i) == text )
      nIndex = i;
    i++;
  }

  return nIndex;
}

/////////////////
class KXmlEditorDraggableLabel : public QLabel
{
public:
    KXmlEditorDraggableLabel(KXMLEditorApp * mw, const QString & text, QWidget * parent = 0, const char * name = 0 )
        : QLabel(text, parent, name), m_mw(mw)
    { validDrag = false; }

protected:
    void mousePressEvent( QMouseEvent * ev )
    	{
        validDrag = true;
        startDragPos = ev->pos();
    	}
    void mouseMoveEvent( QMouseEvent * ev )
    	{	if((startDragPos - ev->pos()).manhattanLength() > QApplication::startDragDistance())
        	{	validDrag = false;

            if( m_mw->currentView() )
            	{ QDragObject *pDragObject = new QTextDrag(m_mw->path(), m_mw);
                pDragObject->setPixmap(KMimeType::pixmapForURL("text/plain", 0, KIcon::Small));
                (void) pDragObject->drag();
            	}
        	}
    	}
    void mouseReleaseEvent( QMouseEvent * )
    {
        validDrag = false;
    }
private:
    QPoint startDragPos;
    bool validDrag;
    KXMLEditorApp * m_mw;
};

//-------------------------------------------------------------------
//
// KXmlEditorLabelAction member functions
//
//-------------------------------------------------------------------

KXmlEditorLabelAction::KXmlEditorLabelAction( const QString &text, QObject *parent, const char *name )
    : KAction( text, 0, parent, name ), m_label( 0L )
{
}

int KXmlEditorLabelAction::plug( QWidget *widget, int index )
{
  //do not call the previous implementation here

  if ( widget->inherits( "KToolBar" ) )
  {
    KToolBar *tb = (KToolBar *)widget;

    int id = KAction::getToolButtonID();

    m_label = new KXmlEditorDraggableLabel( static_cast<KXMLEditorApp *>(tb->mainWindow()), text(), widget );
    m_label->setAlignment( Qt::AlignLeft | Qt::AlignVCenter | Qt::ShowPrefix );
    m_label->adjustSize();
    tb->insertWidget( id, m_label->width(), m_label, index );

    addContainer( tb, id );

    connect( tb, SIGNAL( destroyed() ), this, SLOT( slotDestroyed() ) );

    return containerCount() - 1;
  }

  return -1;
}

void KXmlEditorLabelAction::unplug( QWidget *widget )
{
  if ( widget->inherits("KToolBar"))
  {
    KToolBar *bar = (KToolBar *)widget;

    int idx = findContainer( bar );

    if ( idx != -1 )
    {
      bar->removeItem( menuId( idx ) );
      removeContainer( idx );
    }

    m_label = 0;
    return;
  }
}


