/***************************************************************************
                          kxmleditorfactory.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 byThe KXMLEditor Team 
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxmleditorfactory.h"
#include "kxmleditorpart.h"
#include "kxmleditorabout.h"

#include <kinstance.h>
#include <kdebug.h>

extern "C"
{
	void * init_libkxmleditor()
	{
		return new KXMLEditorFactory;
	}
};

KInstance * KXMLEditorFactory::s_instance = 0L;

KXMLEditorFactory::KXMLEditorFactory( QObject * pParent, const char * pszName )
	: KLibFactory(pParent,pszName)
{
}

KXMLEditorFactory::~KXMLEditorFactory()
{
	if (s_instance)
		delete s_instance;

	s_instance = 0L;
}

QObject * KXMLEditorFactory::create( QObject * pParent, const char * pszName, const char * pszClassName, const QStringList & args )
{
kdDebug() << ">>> KXMLEditorFactory::create" << endl;
	if ( pParent && ! pParent->inherits("QWidget") )
	{
		kdError() << "KXMLEditorFactory::create : parent does not inherit QWidget" << endl;
		return 0L;
	}

	KXMLEditorPart * pPart = new KXMLEditorPart( (QWidget*) pParent, pszName );
kdDebug() << ">>> KXMLEditorFactory::create" << endl;
	emit objectCreated( pPart );
kdDebug() << ">>> KXMLEditorFactory::create" << endl;
	return pPart;
}

KInstance * KXMLEditorFactory::instance()
{
	if ( ! s_instance )
	{
		s_instance = new KInstance( new KXMLEditorAboutData() );
	}
	return s_instance;
}
