/***************************************************************************
                          tablewidget.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABLEWIDGET_H
#define TABLEWIDGET_H

#include <qtable.h>

class XmlElement;

/**
 * Inherits from QTable and extend its functionality.
 * @author Lumir Vanek
 */
class TableWidget : public QTable
{
		Q_OBJECT

	public:
		TableWidget( int numRows, int numCols, QWidget * parent = 0, const char * name = 0 );
		virtual ~TableWidget() {}

	public slots:
		/** Changes/Rebuilds the whole table according to the given element's attributes. */
		void slotChange( XmlElement * const );

	protected:
		/** Called, when mouse event occurs in widget */
		virtual void contentsMousePressEvent(QMouseEvent *);

	signals:
		/** Emited, when user press right mouse button */
		void sigRightButtonPressed(const QPoint&);
};

#endif
