/***************************************************************************
                          xml_base.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klistview.h>
#include "optionsdialog.h"
#include "searchdlg.h"

#include "xml_base.h"

#include "qpixmap.h"

//-------------------------------------------------------------------
//
// XmlAttribute member functions
//
//-------------------------------------------------------------------
XmlAttribute::XmlAttribute(const QString& strName, const QString& strValue)
{
	m_strName = strName;
	m_strValue = strValue;
}

//-------------------------------------------------------------------
//
// XmlTreeItem member functions
//
//-------------------------------------------------------------------

QPixmap* XmlTreeItem::m_pPixmapElement = 0;
QPixmap* XmlTreeItem::m_pPixmapText = 0;
QPixmap* XmlTreeItem::m_pPixmapCDATA = 0;
QPixmap* XmlTreeItem::m_pPixmapComment = 0;
QPixmap* XmlTreeItem::m_pPixmapBookmark = 0;
QPixmap* XmlTreeItem::m_pPixmapProcInstr = 0;

XmlTreeItem::XmlTreeItem(KListView *pParent, const QString& name, const QString& namespaceURI)
	: QListViewItem(pParent, name, namespaceURI)
{
	m_bBookmark = false;
}

XmlTreeItem::XmlTreeItem(QListViewItem *pParent, const QString& name, const QString& namespaceURI)		
	: QListViewItem(pParent, name, namespaceURI)
{
	m_bBookmark = false;
}

QCString XmlTreeItem::m_strSubtypeXML;
QCString XmlTreeItem::m_strSubtypeXML_text;
QCString XmlTreeItem::m_strSubtypeXML_cdata;
QCString XmlTreeItem::m_strSubtypeXML_comment;
QCString XmlTreeItem::m_strSubtypeXML_procins;

/** Return contents type as text string */
const QCString XmlTreeItem::contentsTypeAsText() const
{
	
	switch(itemType())
			{ case XmlTreeItem::itemElement:
																				return m_strSubtypeXML;
																				
				case XmlTreeItem::itemProcInstr:			
																				return m_strSubtypeXML_procins;

				case XmlTreeItem::itemText:			
																				return m_strSubtypeXML_text;
						
				case XmlTreeItem::itemCDATA:			
																				return m_strSubtypeXML_cdata;
							
				case XmlTreeItem::itemComment:		
																				return m_strSubtypeXML_comment;
																																								
			  default:												ASSERT(false);
						
			}
		return "";
}

/** Accept drops of this MIME types ? */
bool XmlTreeItem::acceptsDrops(const QStrList &formats)
{
	if(itemType() == itemElement)
		return (formats.contains("text/" + m_strSubtypeXML) ||
						 formats.contains("text/" + m_strSubtypeXML_text)  ||
						 formats.contains("text/" + m_strSubtypeXML_cdata)  ||
						 formats.contains("text/" + m_strSubtypeXML_comment) ||
						 formats.contains("text/" + m_strSubtypeXML_procins)
						);

	if(itemType() == itemProcInstr)
		return (formats.contains("text/" + m_strSubtypeXML_procins));
	
	// item is Text, CDATA or Comment	
	return (formats.contains("text/" + m_strSubtypeXML_text)  ||
					 formats.contains("text/" + m_strSubtypeXML_cdata)  ||
					 formats.contains("text/" + m_strSubtypeXML_comment) ||
					 formats.contains("text/" + m_strSubtypeXML_procins)
					);
}

/** Test, if item in parameter is my direct or indirect child item */
bool XmlTreeItem::isMyChildren(const XmlTreeItem *pTestItem)
{
	XmlTreeItem* pChildXmlTreeItem = (XmlTreeItem*) firstChild();
  while(pChildXmlTreeItem)
		{ if(pChildXmlTreeItem == pTestItem)
				return true;

			// test child item childrens	
			if(pChildXmlTreeItem->isMyChildren(pTestItem))	
				return true;
				
			pChildXmlTreeItem = (XmlTreeItem*) pChildXmlTreeItem->nextSibling();
    }
	return false;
}


/** Return path for this XML item as string */
QString XmlTreeItem::path(const XmlTreeItem *) const
{
	QString strPath;
	
	// get parent item
	QListViewItem *pParentItem = parent();
	
	// first part of path is parents path
	if(pParentItem)
		{ XmlTreeItem *pXmlTreeItemParent = static_cast <XmlTreeItem *> (pParentItem);
		  strPath = pXmlTreeItemParent->path(this);
		}
		
	// dot separator
	if(strPath.length() > 0)
		strPath += ".";
	
	// its all, last part of path add derived class
	return strPath;
}

/** Search item with path from parameter */
XmlTreeItem * XmlElement::searchPath(const QString & strPath)
{
	if(text(0) == strPath)
		return this;

	int iOpenBracketPos = strPath.find('(');
	if(iOpenBracketPos <= 0)
		return 0;
		
	int iCloseBracketPos = strPath.find(')');
	if(iCloseBracketPos <= 0)
		return 0;
		
	// is searched element on my childs path ?
	QString strSubPath = strPath.mid(0, iOpenBracketPos); // extract element name
	if(text(0) != strSubPath)
		return 0; // No
		
	// get child element index
	bool bOk;
	QString strIndex = strPath.mid(iOpenBracketPos + 1, iCloseBracketPos - iOpenBracketPos - 1);
	int iIndex = strIndex.toInt(&bOk);
	if(!bOk)
		return 0;
		
	// create path for child it
	QString strPathChild = strPath.mid(iCloseBracketPos + 2); // +2 : skip ")."
	
	// send searching to child with index iIndex
	int i = 0;
	XmlTreeItem* pChildXmlTreeItem = (XmlTreeItem*) firstChild();
  while(pChildXmlTreeItem)
		{ if(iIndex == i++)
				{ XmlTreeItem *pFoundXmlTreeItem = pChildXmlTreeItem->searchPath(strPathChild);
				  return pFoundXmlTreeItem;
				}

			pChildXmlTreeItem = (XmlTreeItem*) pChildXmlTreeItem->nextSibling();
    }

	return 0;
}

XmlTreeItem * XmlTreeItem::nextItem()
{
	// checking for a child
	QListViewItem * pTmp = firstChild();
	if (pTmp)
		return static_cast <XmlTreeItem *> (pTmp);

	// there is no child -> checking for the next sibling
	pTmp = nextSibling();
	if (pTmp)
		return static_cast <XmlTreeItem *> (pTmp);

	// there is no next sibling -> checking for parnet's next sibling
	QListViewItem * pParent = parent();
	while (pParent)
	{
		pTmp = pParent->nextSibling();
		if (pTmp)
			return static_cast <XmlTreeItem *> (pTmp);
		pParent = pParent->parent();
	}
	return 0;
}

/** Enable/disable bookmark on this tree item */
bool XmlTreeItem::toggleBookmark()
{
	if(m_bBookmark)
		{ setPixmap(1, QPixmap());
			m_bBookmark = false;
		}
	else
		{ setPixmap(1, *m_pPixmapBookmark);
			m_bBookmark = true;
		}
	return m_bBookmark;
}

/** Expand tree node up to level specified in parameter. /-1: expand entire node/.  */
void XmlTreeItem::expandNode(int iLevel, int iCurrentLevel)
{
	if((iLevel > 0) && (iCurrentLevel >= iLevel))
		return;
		
	// expand this node
	setOpen(true);
	
	// expand my childrens
	XmlTreeItem* pChildXmlTreeItem = (XmlTreeItem*) firstChild();
  while(pChildXmlTreeItem)
			{ // expand child node
		  	pChildXmlTreeItem->expandNode(iLevel, iCurrentLevel >= 0 ? iCurrentLevel + 1 : iCurrentLevel);
				
				pChildXmlTreeItem = (XmlTreeItem*) pChildXmlTreeItem->nextSibling();
  		}
}

/** Collapse tree node from level specified in parameter. /-1: collapse entire node/.  */
  void XmlTreeItem::collapseNode(int iLevel, int iCurrentLevel)
{
	if((iLevel == -1) || (iCurrentLevel >= iLevel))
		{	// expand this node
			setOpen(false);
		}
	
	// collapse my childrens
	XmlTreeItem* pChildXmlTreeItem = (XmlTreeItem*) firstChild();
  while(pChildXmlTreeItem)
		{ // collapse child node
	 		pChildXmlTreeItem->collapseNode(iLevel, iCurrentLevel >= 0 ? iCurrentLevel + 1 : iCurrentLevel);
			
			pChildXmlTreeItem = (XmlTreeItem*) pChildXmlTreeItem->nextSibling();
  	}
}

//-------------------------------------------------------------------
//
// XmlProcessingInstruction member functions
//
//-------------------------------------------------------------------

XmlProcessingInstruction::XmlProcessingInstruction(KListView *pParent, const QString &strTarget, const QString &strData)
	: XmlTreeItem(pParent, strTarget + " " + strData, 0)
{
	m_strTarget = strTarget;
	m_strData = strData;
		
	setPixmap(0, *m_pPixmapProcInstr);
}

XmlProcessingInstruction::XmlProcessingInstruction(QListViewItem *pParent, const QString &strTarget, const QString &strData)
	: XmlTreeItem(pParent, strTarget + " " + strData, 0)
{
	m_strTarget = strTarget;
	m_strData = strData;
		
	setPixmap(0, *m_pPixmapProcInstr);
}



/** Set Target */
void XmlProcessingInstruction::setTargetData(const QString &strTarget, const QString &strData)
{
	m_strTarget = strTarget;
	m_strData = strData;
	setText(0, strTarget + " " + strData);
}

/** Save XML to string */
void XmlProcessingInstruction::save(QString &strXml, unsigned int iTabLevel)
{
	QString strTabs;
	strTabs.fill('\t', iTabLevel);
	
	strXml += strTabs;
	
	strXml += "<?";
	strXml += m_strTarget + " " + m_strData;
	strXml += " ?>";
	
	if(OptionsDialog::getXmlAppendCRLF())
		strXml += "\r\n";
	else
		strXml += "\n";								
}

/** Return path for this XML item as string */
QString XmlProcessingInstruction::path(const XmlTreeItem *pItemCaller) const
{
	QString strPath = XmlTreeItem::path(pItemCaller);
	
	strPath += text(0);
	return strPath;
}

/** Search item with path from parameter */
XmlTreeItem * XmlProcessingInstruction::searchPath(const QString &strPath)
{
	if(text(0) == strPath)
		return this;
		
	return 0;
}

/** Search string in XML element, if not found search in child elements */
XmlTreeItem::enSearchResult XmlProcessingInstruction::searchString(const QString &strSearchedString,
																																 bool bMatchCase,
																																 bool, //bElementNames,
																																 bool, //bAttributeNames,
																																 bool, //bAttributeValues,
																																 bool bContents,
																																 QListViewItem **ppFoundItem, // yes, really pointer to pointer
																																 bool *pbReachedSelectedItem)
{
	// search string in XML contents
	if(bContents && *pbReachedSelectedItem) // TODO tady to neni dodelane !!!
		{ if(m_strData.find(strSearchedString, 0, bMatchCase) >= 0)
					{ *ppFoundItem = this;
						return searchFoundInContents;
					}
		}

	// *ppFoundItem contain pointer to selected item, as input parameter.
	if(*ppFoundItem == this)
		*pbReachedSelectedItem = true;

	return searchNotFound;
}

/** Tests, if the corresponding XML object matches the conditions of the given search. */
bool XmlProcessingInstruction::match( const SearchDlg * const pConditions ) const
{
	// TODO implement later - after extension of SearchDlg for Proc.Instr.'s
	return false;
}

/** Set Proccessing instruction Target and data from string */
bool XmlProcessingInstruction::setContents(const QString &strXML)
{
	int iLength = strXML.length();

	if(iLength < 6)
		return false; // min. string must contain <?x ?>
		
	if(strXML.left(2) != "<?")
		return false;
		
	// Get Proc. Instruction target
	QString strTarget;
	int i = 2;
	while(strXML[i] != ' ')
		{ strTarget += strXML[i++];
			if(i >= iLength)
				return false;
		}
	
	i++; // skip space
	
	int iDataLength = strXML.find("?>", i);
	iDataLength -= i;
		
	if(iDataLength < 0)
		return false;
		
	// Get Proc. Instruction data
	QString strData(strXML.mid(i, iDataLength)); // 4 is <??> length
	
	setTargetData(strTarget, strData);
			
	return true;
}

//-------------------------------------------------------------------
//
// XmlContentsItem member functions
//
//-------------------------------------------------------------------

XmlContentsItem::XmlContentsItem(KListView *pParent, const QString &strContents, enItemType eItemType)
	: XmlTreeItem(pParent, 0, 0)
{
	setContents(strContents);
	setItemType(eItemType);
}

XmlContentsItem::XmlContentsItem(QListViewItem *pParent, const QString &strContents, enItemType eItemType)
	: XmlTreeItem(pParent, 0, 0)
{
	setContents(strContents);
	setItemType(eItemType);
}

void XmlContentsItem::setContents(const QString &strContents)
{
	m_strContents = strContents;
	
	unsigned int iLength;
	QString strName;
	
	int iCrPosition = strContents.find('\n'); // contain line break ?
	if(iCrPosition >= 0)
		{ // find first line with text, that can be used as name
			do
			 {	QString strLine = m_strContents.mid(0, iCrPosition + 1);
					iLength  = strLine.length();
					m_strContents.remove(0, iLength);
						
					if(containUsefulCharacter(strLine))
						{ iCrPosition = strLine.find('\n');
							if(iCrPosition > 0)
								strLine.replace(iCrPosition, 1, " ");

						  strName += strLine;
						}
						
					iCrPosition = m_strContents.find('\n');
					
					if(iCrPosition < 0)
						strName += m_strContents;
				 }
			while((iCrPosition >= 0) && (strName.length() < 10));
		}
	else
		{ strName = strContents;
		}
		
	// remove heading spaces, \t, \n, \r from string
	strName = removeUselessCharacters(strName);
	
	// reduce name length, if necessary	
	iLength = strName.length();
	if(iLength > 30)
			{ strName = strName.left(30) + "...";
			}
			
	setText(0, strName);
	m_strContents = strContents;
}

void XmlContentsItem::setItemType(enItemType eItemType)
{
		m_eItemType = eItemType;
		
		switch(m_eItemType)
			{ case XmlTreeItem::itemText:			
																				setPixmap(0, *m_pPixmapText);
																				break;
						
				case XmlTreeItem::itemCDATA:			
																				setPixmap(0, *m_pPixmapCDATA);
																				break;
							
				case XmlTreeItem::itemComment:		
																				setPixmap(0, *m_pPixmapComment);
																				break;
																				
			  default:												ASSERT(false);
						
			}
}

/** Save XML to string */
void XmlContentsItem::save(QString &strXml, unsigned int iTabLevel)
{
	QString strTabs;
	strTabs.fill('\t', iTabLevel);

	switch(itemType())
			{ case XmlTreeItem::itemText:			
																			strXml += prepareXmlForSave(m_strContents);
																			break;
															
				case XmlTreeItem::itemCDATA:			
																			strXml += "<![CDATA[";
																			strXml += m_strContents;
																			strXml += "]]>";
																			break;
								
				case XmlTreeItem::itemComment:		
																			strXml += "<!-- ";
																			strXml += m_strContents;
																			strXml += " -->";
																			if(OptionsDialog::getXmlAppendCRLF())
																				strXml += "\r\n";
																			else
																				strXml += "\n";	
																			break;

			  default:									ASSERT(false);
			}
}


/** Return path for this XML item as string */
QString XmlContentsItem::path(const XmlTreeItem *pItemCaller) const
{
	QString strPath = XmlTreeItem::path(pItemCaller);
	
	strPath += text(0);
	return strPath;
}

/** Search item with path from parameter */
XmlTreeItem * XmlContentsItem::searchPath(const QString &strPath)
{
	if(text(0) == strPath)
		return this;
		
	return 0;
}

/** Search string in XML element, if not found search in child elements */
XmlTreeItem::enSearchResult XmlContentsItem::searchString(const QString &strSearchedString,
																																 bool bMatchCase,
																																 bool, //bElementNames,
																																 bool, //bAttributeNames,
																																 bool, //bAttributeValues,
																																 bool bContents,
																																 QListViewItem **ppFoundItem, // yes, really pointer to pointer
																																 bool *pbReachedSelectedItem)
{
	// search string in XML contents
	if(bContents && *pbReachedSelectedItem)
		{ if(m_strContents.find(strSearchedString, 0, bMatchCase) >= 0)
					{ *ppFoundItem = this;
						return searchFoundInContents;
					}
		}

	// *ppFoundItem contain pointer to selected item, as input parameter.
	if(*ppFoundItem == this)
		*pbReachedSelectedItem = true;

	return searchNotFound;
}

/** Tests, if the corresponding XML object matches the conditions of the given search. */
bool XmlContentsItem::match( const SearchDlg * const pConditions ) const
{
	if ( pConditions->m_bContents )
	{
		if ( m_strContents.find(pConditions->m_strSearchedString, 0, pConditions->m_bMatchCase) >= 0 )
			return true;
		else
			return false;
	}
	else
		return false;
}

//-------------------------------------------------------------------
//
// XmlElement member functions
//
//-------------------------------------------------------------------

XmlElement::XmlElement(KListView *pParent, const QString& strName, const QString& namespaceURI)
	: XmlTreeItem(pParent, strName, namespaceURI)
{
	m_listOfAttributes.setAutoDelete(true);		// automaticaly cleanup memory when destructing
	setPixmap(0, *m_pPixmapElement);
}

XmlElement::XmlElement(QListViewItem *pParent, const QString& strName, const QString& namespaceURI)
	: XmlTreeItem(pParent, strName, namespaceURI)
{
	m_listOfAttributes.setAutoDelete(true);		// automaticaly cleanup memory when destructing
  setPixmap(0, *m_pPixmapElement);
}

/** Search string in XML element, if not found search in child elements */
XmlTreeItem::enSearchResult XmlElement::searchString(const QString &strSearchedString,
																													 	bool bMatchCase,
																														bool bElementNames,
																														bool bAttributeNames,
																														bool bAttributeValues,
																														bool bContents,
																														QListViewItem **ppFoundItem, // yes, really pointer to pointer
																														bool *pbReachedSelectedItem)
{
	// search string in XML element name
	if(bElementNames && *pbReachedSelectedItem)
		{ if(text(0).find(strSearchedString, 0, bMatchCase) >= 0)
				{ *ppFoundItem = this;
					return searchFoundInElementName;
				}
		}

	// search string in attributes list
	if((bAttributeNames || bAttributeValues) && *pbReachedSelectedItem)
		{ unsigned int i;
      for(i = 0; i < m_listOfAttributes.count(); i++)
				{ if(bAttributeNames)
						{ if(m_listOfAttributes.at(i)->name().find(strSearchedString, 0, bMatchCase) >= 0)
								{ *ppFoundItem = this;
									return searchFoundInAttributeName;
								}
						}

					if(bAttributeValues)
						{ if(m_listOfAttributes.at(i)->value().find(strSearchedString, 0, bMatchCase) >= 0)
								{ *ppFoundItem = this;
									return searchFoundInAtributeValue;
								}
						}
				}
		}


	// *ppFoundItem contain pointer to selected item, as input parameter.
	// We must start search in *ppFoundItem *childs*, not in *ppFoundItem.
	if(*ppFoundItem == this)
		*pbReachedSelectedItem = true;

	// search string in our children elements list
	XmlTreeItem* pChildXmlTreeItem = (XmlTreeItem*) firstChild();
  while(pChildXmlTreeItem)
		{ enSearchResult searchResult;

			searchResult = pChildXmlTreeItem->searchString(strSearchedString,
																													 bMatchCase,
																													 bElementNames,
																													 bAttributeNames,
																													 bAttributeValues,
																													 bContents,
																													 ppFoundItem,
																													 pbReachedSelectedItem
																							 		 				);
			if(searchResult > searchNotFound)
					return searchResult;

      pChildXmlTreeItem = (XmlTreeItem*) pChildXmlTreeItem->nextSibling();
    }

	return searchNotFound;
}

/** Tests, if the corresponding XML object matches the conditions of the given search. */
bool XmlElement::match( const SearchDlg * const pConditions ) const
{
	if ( ( pConditions->m_bElementNames ) &&
	     ( text(0).find( pConditions->m_strSearchedString, 0, pConditions->m_bMatchCase ) >= 0 ) )
		return true;

	if ( ( ! pConditions->m_bAttributeNames ) && ( ! pConditions->m_bAttributeValues ) )
		return false;

	for ( QListIterator<XmlAttribute> it(m_listOfAttributes); it.current(); ++it )
	{
		if ( ( pConditions->m_bAttributeNames ) &&
		     ( it.current()->name().find(pConditions->m_strSearchedString, 0, pConditions->m_bMatchCase) >= 0 ) )
			return true;

		if ( ( pConditions->m_bAttributeValues ) &&
		     ( it.current()->value().find(pConditions->m_strSearchedString, 0, pConditions->m_bMatchCase) >= 0 ) )
			return true;
	}

	return false;
}

/** Save XML to string */
void XmlElement::save(QString &strXml, unsigned int iTabLevel)
{
	QString strTabs;
	strTabs.fill('\t', iTabLevel);

	// XML element name
	strXml += strTabs + "<" + text(0);

	// XML attributes list
	XmlAttribute* pXmlAttribute;

	for(pXmlAttribute = m_listOfAttributes.first();
			pXmlAttribute != 0;
			pXmlAttribute = m_listOfAttributes.next())
		{ strXml += ' ';
		  strXml += pXmlAttribute->name();
		  strXml += "=\"";
		  strXml += prepareXmlForSave(pXmlAttribute->value());
		  strXml += '\"';
		}
		
	// children XML elements
	XmlTreeItem* pChildXmlTreeItem = static_cast<XmlTreeItem *> (firstChild());
	
	if((pChildXmlTreeItem == 0))
		{ strXml += "/>";
			if(OptionsDialog::getXmlAppendCRLF())
				strXml += "\r\n";
			else
			strXml += "\n";	
		
			return;
		}
	
	strXml += ">";
	
	// count child elements
	unsigned int nChilds = 0;	
  while(pChildXmlTreeItem)
  	{ if(pChildXmlTreeItem->itemType() == XmlTreeItem::itemElement)
				nChilds++;
	
  	  pChildXmlTreeItem = static_cast<XmlTreeItem *> (pChildXmlTreeItem->nextSibling());	
  	}

	if(nChilds > 0)
		{ if(OptionsDialog::getXmlAppendCRLF())
				strXml += "\r\n";
			else
				strXml += "\n";	
		}
		
	// save child elements
	pChildXmlTreeItem = (XmlTreeItem*) firstChild();
	while(pChildXmlTreeItem)
  	{ pChildXmlTreeItem->save(strXml, iTabLevel + 1);
  	  pChildXmlTreeItem = (XmlTreeItem*) pChildXmlTreeItem->nextSibling();
  	}
  	
  	
	if(nChilds > 0)	
			strXml += strTabs;

	// close tag
	strXml += "</" + text(0) + ">";
	
	if(OptionsDialog::getXmlAppendCRLF())
		strXml += "\r\n";
	else
		strXml += "\n";			
}

/** Return path for this XML item as string */
QString XmlElement::path(const XmlTreeItem *pItemCaller) const
{
	QString strPath = XmlTreeItem::path(pItemCaller);
	
	// element name
	strPath += text(0);
	
	// look at child (caller) element sequence
	int iSequence = 0;
	
	XmlTreeItem* pChildXmlTreeItem = static_cast<XmlTreeItem *> (firstChild());
	while(pChildXmlTreeItem)
  	{ if(pItemCaller == pChildXmlTreeItem)
  			{ strPath += "(" + QString::number(iSequence) + ")";
  				break;
  			}
  			
  		iSequence++;
  	  pChildXmlTreeItem = (XmlTreeItem*) pChildXmlTreeItem->nextSibling();
  	}
	
	return strPath;
}

/** Update column with list of attributes */
void XmlElement::updateStringAttrList()
{
	if(OptionsDialog::getTreeViewElemDisplayMode() == 0)
		return;
	
	QString	strAttributesList;
	
	XmlAttribute* pXmlAttribute;
	for(pXmlAttribute = m_listOfAttributes.first();
			pXmlAttribute != 0;
			pXmlAttribute = m_listOfAttributes.next())
				{ if(OptionsDialog::getTreeViewElemDisplayMode() >= 1)
			  		{ strAttributesList += " " + pXmlAttribute->name();
			  		}
			  	if(OptionsDialog::getTreeViewElemDisplayMode() >= 2)
			  		{ strAttributesList += "=\"" + pXmlAttribute->value() + "\"";
			  		}
				}
	setText(2, strAttributesList);
	
	//--- Make this on our childrens ----------------------------------
	QListViewItem* pChildItem = firstChild();
	if(!pChildItem)
		return;
	
	do
		{ XmlTreeItem* pTreeItem = static_cast <XmlTreeItem *> (pChildItem);
			
			if(pTreeItem->itemType() == XmlTreeItem::itemElement)
				{ XmlElement* pXmlElement = static_cast <XmlElement *> (pTreeItem);				
				  pXmlElement->updateStringAttrList();
				}
		} while((pChildItem = pChildItem->nextSibling()) != 0);
}

//-------------------------------------------------------------------
//
// Global helper functions
//
//-------------------------------------------------------------------

/** Replaces special characters with appropriate equvivalents */
QString prepareXmlForSave(const QString &strSource)
{
	QString strDestination;
	
	unsigned int iLength = strSource.length();
	
	unsigned int i;
	for(i = 0; i < iLength; i++)
		{ switch(strSource[i])
				{ case '<':	strDestination += "&lt;";
											break;
											
					case '>':	strDestination += "&gt;";
											break;
											
				  case '&':	  if(OptionsDialog::getXmlDontConvertAmpersand())
				  							strDestination += strSource[i];
				  						else
				  							strDestination += "&amp;";
											break;
											
					case '\"':	strDestination += "&quot;";
											break;
											
					case '\'':	strDestination += "&apos;";
											break;
											
				  default:  { QChar ch(strSource[i]);
				  						if(ch.row() > 0)
				  							{ QString strRepresentation;
				  								strRepresentation.sprintf("&#x%x;", ch.unicode()); // french oe ligature will be saved as &#x153; etc
				  								
				  								if(OptionsDialog::getListOfSpecCharacters().contains(strRepresentation))
				  									strDestination += strRepresentation;
				  								else
				  									strDestination += strSource[i];
				  							}
				  						else
				  							strDestination += strSource[i];
				  					}
				}
		}
	return strDestination;
}

/** Test string, if contain any useful character */
bool containUsefulCharacter(const QString &strSource)
{
	unsigned int iLength = strSource.length();
	unsigned int i;
	
	for(i = 0; i < iLength; i++)
		{ switch(strSource[i])
				{ case ' ':
					case '\t':	
					case '\r':
					case '\n':		
											break;
											
				  default:		return true;		
				}
		}
	return false;
}

/** Remove useless characters from string */
QString removeUselessCharacters(const QString &strSource)
{
	unsigned int iLength = strSource.length();
	unsigned int i;
	QString strDestination;
	bool bHeadingSpace = true;
	
	for(i = 0; i < iLength; i++)
		{ switch(strSource[i])
				{ case ' ':
											if(!bHeadingSpace)
												strDestination += strSource[i];	
												
											break;
					case '\t':	
					case '\r':
					case '\n':		
											break;
											
				  default:		strDestination += strSource[i];	
				  						bHeadingSpace = false;	
				}
		}
	return strDestination;
}
