/***************************************************************************
                          kxeattributedialog.h  -  description
                          --------------------
    begin                : Fre Jul 12 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXEATTRIBUTEDIALOG_H
#define KXEATTRIBUTEDIALOG_H

#include "kxeattributedialogbase.h"

#include <qdom.h>

class KXEAttributeDialog : public KXEAttributeDialogBase
{
		Q_OBJECT

	public:
		KXEAttributeDialog( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

    const QString attributeNamespace() const { return m_strNamespace; }
    const QString QName() const { return m_strQName; }
    const QString Value() const { return m_strValue; }
    
		/**
		 * To be used for adding an attribute to new XML element.
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( );

		/**
		 * Clears the dialogs widgets.
		 */
		void clearDialog();

    // Check, if XML attribute name is OK
    static QString checkName(const QString);

    // Check, if XML attribute value is OK
    static QString checkValue(const QString);

    // Check, if XML attribute namespace is OK
    static QString checkNamespace(const QString);

	protected slots:
		/**
		 * Called, when user change attribute name.
		 * Disables the OK button, if user input is wrong or incomplete.
		 */
		void slotNameChanged(const QString &);

    /**
		 * Called, when user change attribute value.
		 * Disables the OK button, if user input is wrong or incomplete.
		 */
    void slotValueChanged(const QString &);

    /**
		 * Called, when user change attribute namespace.
		 * Disables the OK button, if user input is wrong or incomplete.
		 */
     void slotNamespaceChanged(const QString &);

  protected:
    QString m_strNamespace;
    QString m_strQName;
    QString m_strValue;
};

#endif
