#! /bin/ksh
#
# Copyright 1998-1999, University of Notre Dame.
# Authors: Jeffrey M. Squyres, Kinis L. Meyer, with M. D. McNally 
#          and Andrew Lumsdaine
#
# This file is part of the Notre Dame LAM implementation of MPI.
#
# You should have received a copy of the License Agreement for the
# Notre Dame LAM implementation of MPI along with the software; see
# the file LICENSE.  If not, contact Office of Research, University of
# Notre Dame, Notre Dame, IN 46556.
#
# Permission to modify the code and to distribute modified code is
# granted, provided the text of this NOTICE is retained, a notice that
# the code was modified is included with the above COPYRIGHT NOTICE and
# with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
# file is distributed with the modified code.
#
# LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
# By way of example, but not limitation, Licensor MAKES NO
# REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
# PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
# OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
# OR OTHER RIGHTS.
#
# Additional copyrights may follow.
#
#
#	Ohio Trollius
#	Copyright 1996 The Ohio State University
#	NJN
#
#	Function:	- outputs dependency information
#

#
# Form object file name based on source file name.
#
set -A a -- "$@"
src=${a[$#-1]}
tail=${src##*/}
root=${tail%.*}
ext=${tail##*.}
obj=${root}.o

#
# Generate dependencies from C preprocessor.
#

${LAMCPP} "$@" | grep '^#.*\"' | grep -v '^#pragma' | \
grep -v '^#ident' | sed -e 's/#.*\"\(.*\)\".*$/'${obj}': \1/' | sort -u -

#
# Generate dependency and rule for source to object.
#
if [ "$ext" = c ]; then
	echo ${obj}: ${src} '; $(CC) $(CFLAGS) $(LCFLAGS) -c' ${src}
elif [ "$ext" = s ]; then
	echo ${obj}: ${src} '; $(CPP) $(CPPFLAGS) -P $(ASFLAGS)' ${src} '>' temp.s '; $(AS) -o' ${obj} temp.s '; $(RM)' temp.s
fi
