/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: cfreekey.c,v 1.1 1999/09/04 21:59:38 jsquyres Exp $
 *
 *	Function:	- free communicator attribute key
 *	Accepts:	- key value (in-out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Comm_free_keyval(key)

int			*key;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMFREEKEYVAL);
/*
 * Check the arguments.
 */
	if (key == 0) {
		return(lam_err_comm(MPI_COMM_WORLD, MPI_ERR_ARG, 0,
			"null pointer"));
	}
/*
 * Free the key, if it is valid.
 */
	if (lam_freekey(*key, LAM_AKCOMM) != MPI_SUCCESS) {
		return(lam_err_comm(MPI_COMM_WORLD, MPI_ERR_KEYVAL, 0, ""));
	}

	*key = MPI_KEYVAL_INVALID;

	lam_resetfunc(BLKMPICOMMFREEKEYVAL);
	return(MPI_SUCCESS);
}
