/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: attrget_f.c,v 6.6 1999/10/24 00:39:13 jsquyres Exp $
 *
 *	Function:	- MPI_Attr_get F77 wrapper
 */

#include <lam_config.h>

#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void 
mpi_attr_get_(c, k, a, f, ierr)

int	*c, *k, *a, *f, *ierr;

{
	struct _attrkey *pk;
	void *value;
	int *ip = (int*) &value;

	*ierr = MPI_Attr_get(GETHDL(*c), *k, &value, f);

	if (*ierr == MPI_SUCCESS && *f) {

		pk = lam_getattr(*k);

		if (pk->ak_flags & LAM_LANGF77) {
/*
 * This stuff is very confusing.  Be sure to see MPI-2 4.12.7.
 */
/*
 * If this attribute was created in fortran, we'll get a pointer back
 * to the integer.  But if sizeof(void*) > sizeof(int), the pointer to
 * the value can be viewed as an array of integers -- we need to
 * select the lower (sizeof(int)*8) bits to return.
 */
		  *a = ((int *) value)[lam_int_pos()];
		} else {
/*
 * However, if this attribute was created in C, we need to grab just
 * the lower (sizeof(int)*8) bits, since sizeof(int) may be <
 * sizeof(void*) -- don't dereference it to be an int value.
 */
		  *a = ip[lam_int_pos()];
		}
	}
}
