/* ex: set ts=4: */
/*
	generic, configurable, efficient ash table of linked lists
*/

#ifndef LHASH_H
#define LHASH_H

#include "setup.h"
#include "types.h"

#if defined(WIN32) && !defined(TIGER)
	#include <windows.h> /* NOTE: what does this provide that we need? make notes! */
#elif defined LINUX
	/* nada */
#endif

#include "list.h"
#include "misc.h" /* strings */

#define LHASH_ERR (-1) /* index-related error */ /* FIXME: obsolete? */
#define LHASH_FUNC_VAL_CMP_DEFAULT	vxstrcmp /* FIXME: goddammit */

typedef struct {
	int unsigned (*func_hash)(const void *); /* hashing function */
	int (*func_key_cmp)(const void *, const void *); /* hash comparison function */
	int (*func_val_cmp)(const void *, const void *); /* hash comparison function */
	void * (*func_key_copy)(void *); /* how to set a key */
	void (*func_key_free)(void *); /* how to free a key */
	void * (*func_val_copy)(void *); /* how to set a val */
	void (*func_val_free)(void *); /* how to free a val */
	int unsigned slots; /* number of slots a key can fall under */
	int unsigned count; /* number of items currently in the hash */
	int unsigned bitmask; /* relevant bits used for hashing */
	list_t **data; /* where the data lies */
} lhash_t;

typedef struct {
	void *key;
	void *val;
} lhash_entry_t;

/* structure represents state of a hash keys traversal */
typedef struct {
	lhash_t *table;
	int unsigned curr_slot;
	list_node_t *curr_node;
	bool done;
} lhash_each_t;

/********************* lhash_entry_t functions *****************************/
lhash_entry_t * lhash_entry_new(lhash_t *, const void *, const void *);
bool lhash_entry_add(lhash_t *, list_t *, lhash_entry_t *);
bool lhash_entry_remove(lhash_t *, list_t *, list_node_t *);
lhash_entry_t * lhash_entry_clone(lhash_t *, lhash_entry_t *);
bool lhash_entry_free(lhash_t *, lhash_entry_t *);
#define lhash_entry_key(e)	((e)->key)
#define lhash_entry_val(e)	((e)->val)

/*********************** lhash_t functions *********************************/
lhash_t * lhash_new(
	int unsigned, /* number of slots */
	int unsigned (*)(const void *), /* hash function */
	int (*)(const void *, const void *) /* cmp function */
);
lhash_t * lhash_new_ez(const int unsigned);
bool lhash_init(
	lhash_t *,
	int unsigned, /* number of slots */
	int unsigned (*)(const void *), /* hash function */
	int (*)(const void *, const void *) /* cmp function */
);
bool lhash_init_ez(lhash_t *, const int unsigned);
void lhash_set_key_funcs(lhash_t *, void * (*)(void *), void (*)(void *));
	void lhash_set_key_func_cmp(lhash_t *, int (*)(const void *, const void *));
	void lhash_set_key_func_copy(lhash_t *, void * (*)(void *));
	void lhash_set_key_func_free(lhash_t *, void (*)(void *));
void lhash_set_val_funcs(lhash_t *, void * (*)(void *), void (*)(void *));
	void lhash_set_val_func_cmp(lhash_t *, int (*)(const void *, const void *));
	void lhash_set_val_func_copy(lhash_t *, void * (*)(void *));
	void lhash_set_val_func_free(lhash_t *, void (*)(void *));
#define lhash_size(ht)			((ht)->count)
#define lhash_slots(ht)			((ht)->slots)
bool lhash_destroy(lhash_t *);
bool lhash_free(lhash_t *);
void lhash_free_cb(void *);
void * lhash_get(lhash_t *, const void *);
void * lhash_get_cb(lhash_t *, const void *, int (*cmp)(const void *, const void *)); /* custom get, override func_key_cmp */
bool lhash_set(lhash_t *, const void *, const void *);
#define lhash_put(tbl, k, v)	(lhash_set(tbl, k, v)) /* DEPRECATED: use lhash_set() instead */
bool lhash_set_all(lhash_t *, const void *);
bool lhash_key_exists(lhash_t *, const void *);
bool lhash_delete(lhash_t *, const void *);
bool lhash_delete_all(lhash_t *);

/* functions applying to every item in an lhash */
bool lhash_map(lhash_t *, void (*)(lhash_entry_t *));
bool lhash_map_data(lhash_t *, void (*)(void *));
list_t * lhash_keys(lhash_t *);

/* traverse the keys or key/value pairs of an lhash */
bool lhash_each_reset(lhash_each_t *, lhash_t *);
lhash_entry_t * lhash_next(lhash_each_t *);

int lhash_cmp(lhash_t *, lhash_t *);

/* internal stuff */
/* don't make this static, anything extending lhash needs it! */
int unsigned lhash_key_to_index(lhash_t *, const void *);
list_node_t * lhash_key_to_node(lhash_t *, list_t **, const void *);
int lhash_cmp_str(const void *, const void *); /* a default cmp function for use with lhash_new_ez */

void lhash_dump(lhash_t *); /* dump lhash structure to stdout */

#endif

