/* -*-C-*-

$Id: server.c,v 1.3 2001/03/11 00:39:13 cph Exp $

Copyright (C) 2000-2001 Massachusetts Institute of Technology

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <syslog.h>
#include <pwd.h>
#include <sys/types.h>

#include "server.h"

void
run_in_background (const char * effective_user, const char * pid_file)
{
  pid_t pid = (fork ());
  if (pid < 0)
    {
      syslog ((LOG_DAEMON | LOG_INFO), "Unable to start child process: %s",
	      (strerror (errno)));
      exit (1);
    }
  else if (pid > 0)
    {
      if (pid_file != 0)
	{
	  FILE * s = (fopen (pid_file, "w"));
	  if (s == 0)
	    syslog ((LOG_DAEMON | LOG_INFO), "Unable to open PID file: %s",
		    (strerror (errno)));
	  else
	    {
	      fprintf (s, "%d\n", pid);
	      fclose (s);
	      syslog ((LOG_DAEMON | LOG_INFO), "PID file written: %s",
		      pid_file);
	    }
	}
      exit (0);
    }
  maybe_become_user (effective_user);
  close (0);
  close (1);
  close (2);
  setsid ();
}

void
maybe_become_user (const char * user_name)
{
  if ((user_name != 0) && ((getuid ()) == 0))
    {
      struct passwd * pw = (getpwnam (user_name));
      if (pw == 0)
	{
	  syslog ((LOG_DAEMON | LOG_INFO),
		  "User %s doesn't exist; can't change program owner.",
		  user_name);
	  exit (1);
	}
      if ((setuid (pw -> pw_uid)) < 0)
	{
	  syslog ((LOG_DAEMON | LOG_INFO), "Unable to change to user %s: %s",
		  user_name, (strerror (errno)));
	  exit (1);
	}
    }
}
