/* vim: set noet ts=4:
 *
 * Copyright (c) 2002-2004 Martin A. Godisch <martin@godisch.de>.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 */
#ifndef _SCREEN_H
#define _SCREEN_H

#define COLOR_BACK  1
#define COLOR_LINE  2
#define COLOR_KEY   3
#define COLOR_INPUT 4

#define L10N_NORMAL  _("normal")
#define L10N_REVERSE _("reverse")
#define L10N_MIXED   _("mixed")

#define MAX_LANG    12
#define MAX_KEYMAP 256

#define KEY_TAB      9
#define KEY_CTRL_L  12
#define KEY_RETURN  13
#define KEY_CTRL_U  21
#define KEY_ESC     27
#define KEY_F1     265
#define KEY_F2     266
#define KEY_F3     267
#define KEY_F4     268

extern int sx, sy;

void init_screen(int);
void running(void);
int  endwin(void);
const char *curses_version(void);

#endif
