/*
 * $Id: arch.c,v 1.2 2005/02/23 01:09:04 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2005 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

/*
 * dumparch_init()
 */
int
dumparch_init(int dumparch, FILE* ofp)
{
	switch(dumparch){
#ifdef DUMP_ARCH_ALPHA
	case KL_ARCH_ALPHA:
		if(dumparch_init_alpha(ofp)){
			return(1);
		}
		break;
#endif
#ifdef DUMP_ARCH_ARM
	case KL_ARCH_ARM:
		if(dumparch_init_arm(ofp)){
			return(1);
		}
		break;
#endif
#ifdef DUMP_ARCH_I386
	case KL_ARCH_I386:
		if(dumparch_init_i386(ofp)){
			return(1);
		}
		break;
#endif
#ifdef DUMP_ARCH_IA64
	case KL_ARCH_IA64:
	case KL_ARCH_IA64_SN2:
	case KL_ARCH_IA64_DIG:
	case KL_ARCH_IA64_HPSIM:
	case KL_ARCH_IA64_HPZX1:
		if(dumparch_init_ia64(ofp)){
			return(1);
		}
		break;
#endif
#ifdef DUMP_ARCH_PPC64
	case KL_ARCH_PPC64:
		if(dumparch_init_ppc64(ofp)){
			return(1);
		}
		break;
#endif
#ifdef DUMP_ARCH_S390
	case KL_ARCH_S390:
		if(dumparch_init_s390(ofp)){
			return(1);
		}
		break;
#endif
#ifdef DUMP_ARCH_S390X
	case KL_ARCH_S390X:
		if(dumparch_init_s390x(ofp)){
			return(1);
		}
		break;
#endif
#ifdef DUMP_ARCH_X86_64
	case KL_ARCH_X86_64:
		if(dumparch_init_x86_64(ofp)){
			return(1);
		}
		break;
#endif
	default:
		/* XXX set error code */
		return(1);
	}
	dis_init(ofp, dumparch);
	trace_init(dumparch);

	return(0);
}
