/*
 * $Id: lc_trace_ppc64.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#define STACK_SEGMENTS_PPC64	1
#define STACK_SIZE_PPC64	KL_KSTACK_SIZE_PPC64

#define TF_TRACEREC_VALID  0x01 /* The trace_rec_s has been setup already!   */
#define TF_SUPPRESS_HEADER 0x02 /* Suppress header output from trace cmds    */

/* Stack types
 */
#define S_USERSTACK	0
#define S_KERNELSTACK	1

/* Machine State Register (MSR) Fields */

#define __MASK_PPC64(X)       (1UL<<(X))

#define MSR_DR_PPC64	__MASK_PPC64(4)
#define MSR_IR_PPC64	__MASK_PPC64(5)
#define MSR_ME_PPC64	__MASK_PPC64(12)
#define MSR_FP_PPC64	__MASK_PPC64(13)
#define MSR_PR_PPC64	__MASK_PPC64(14)
#define MSR_EE_PPC64	__MASK_PPC64(15)

/* Function prototypes
 */
int setup_trace_rec_ppc64(kaddr_t, kaddr_t, int, trace_t *);
int find_trace_ppc64(kaddr_t, kaddr_t, kaddr_t, kaddr_t, trace_t *, int);
int print_traces_ppc64(kaddr_t, int, int, FILE *);
void print_trace_ppc64(trace_t *, int, FILE *);
int task_trace_ppc64(kaddr_t, int, FILE *);
int do_list_ppc64(kaddr_t, int, FILE *);
int trace_init_ppc64(void);
int dumptask_trace_ppc64(kaddr_t, int, FILE *);
