/*
 * $Id: kl_dump_i386.h,v 1.1 2004/12/21 23:26:21 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

/* This header file holds the architecture specific crash dump header */
#ifndef __KL_DUMP_I386_H
#define __KL_DUMP_I386_H

/* macros
 */
#ifndef KL_NR_CPUS
#define KL_NR_CPUS 128     /* max number CPUs */
#endif

#define KL_DUMP_MAGIC_NUMBER_I386     0xdeaddeadULL  /* magic number         */
#define KL_DUMP_VERSION_NUMBER_I386   0x3        /* version number          */

/* structures
 */

/* asm independent version of struct pt_regs for i386 */
struct kl_pt_regs_i386 {
	uint32_t ebx;       /* long */
	uint32_t ecx;       /* long */
	uint32_t edx;       /* long */
	uint32_t esi;       /* long */
	uint32_t edi;       /* long */
	uint32_t ebp;       /* long */
	uint32_t eax;       /* long */
	uint32_t xds;       /* int */
	uint32_t xes;       /* int */
	uint32_t orig_eax;  /* long */
	uint32_t eip;       /* long */
	uint32_t xcs;       /* int */
	uint32_t eflags;    /* long */
	uint32_t esp;       /* long */
	uint32_t xss;       /* int */
}__attribute__((packed));

/*  Header for architecture-specific stuff.
 *  It follows right after the dump header.
 */
typedef struct kl_dump_header_i386_s {
        uint64_t               magic_number; /* magic number for architecture */
        uint32_t               version;     /* version number of this dump */
        uint32_t               header_size; /* size of this header */
	uint32_t               esp;  /* esp for i386 systems */
	uint32_t               eip;  /* eip for i386 systems */
	struct kl_pt_regs_i386 regs; /* the dump registers */
	/* smp specific */
	uint32_t               smp_num_cpus;
	uint32_t               dumping_cpu;	
	struct kl_pt_regs_i386 smp_regs[KL_NR_CPUS];
	uint32_t               smp_current_task[KL_NR_CPUS];
	uint32_t               stack[KL_NR_CPUS];
	uint32_t               stack_ptr[KL_NR_CPUS];
} __attribute__((packed)) kl_dump_header_i386_t;

/*
 * The following struct is used just to calculate the size needed
 * to store per CPU info. (Make sure it is sync with the above struct)
 */
struct kl_dump_CPU_info_i386 {
       struct kl_pt_regs_i386          smp_regs;
       uint64_t                        smp_current_task;
       uint64_t                        stack;
       uint64_t                        stack_ptr;
} __attribute__((packed));

/* function declarations
 */
kaddr_t kl_dumpeip_i386(kaddr_t);
kaddr_t kl_dumpesp_i386(kaddr_t);
int kl_get_dump_header_i386(kl_dump_header_i386_t*);
int kl_smp_dumptask_i386(kaddr_t);
int kl_set_dumparch_i386(void);

#endif /* __KL_DUMP_I386_H */
