/*
 * $Id: kl_dump_ppc64.h,v 1.1 2004/12/21 23:26:21 tjm Exp $
 * 
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 * 
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 * 
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

/* This header file holds the architecture specific crash dump header */
#ifndef __KL_DUMP_PPC64_H
#define __KL_DUMP_PPC64_H

/* necessary header files */
#include <linux/threads.h>

#ifndef KL_NR_CPUS
# define KL_NR_CPUS  128    /* max number CPUs */
#endif


/* definitions */
#define KL_DUMP_MAGIC_NUMBER_PPC64     0xdeaddeadULL  /* magic number      */
#define KL_DUMP_VERSION_NUMBER_PPC64   0x5       /* version number         */

#define KL_KSTACK_SIZE_PPC64     0x4000
#define KL_STACK_FRAME_OVERHEAD_PPC64    112
#define KL_PPC_REG_PPC64 uint64_t

struct kl_pt_regs_ppc64 {
	KL_PPC_REG_PPC64 gpr[32];
	KL_PPC_REG_PPC64 nip;
	KL_PPC_REG_PPC64 msr;
	KL_PPC_REG_PPC64 orig_gpr3;      /* Used for restarting system calls */
	KL_PPC_REG_PPC64 ctr;
	KL_PPC_REG_PPC64 link;
	KL_PPC_REG_PPC64 xer;
	KL_PPC_REG_PPC64 ccr;
	KL_PPC_REG_PPC64 softe;          /* Soft enabled/disabled */
	KL_PPC_REG_PPC64 trap;           /* Reason for being here */
	KL_PPC_REG_PPC64 dar;            /* Fault registers */
	KL_PPC_REG_PPC64 dsisr;
	KL_PPC_REG_PPC64 result;         /* Result of a system call */
};

/*
 * Structure: dump_header_asm_t
 *  Function: This is the header for architecture-specific stuff.  It
 *            follows right after the dump header.
 */
typedef struct kl_dump_header_ppc64_s {

        /* the dump magic number -- unique to verify dump is valid */
        uint64_t             		magic_number;

        /* the version number of this dump */
        uint32_t             		version;

        /* the size of this header (in case we can't read it) */
        uint32_t             		header_size;

	/* the dump registers */
	struct kl_pt_regs_ppc64       	regs;

	/* smp specific */
	uint32_t	     		smp_num_cpus;
	int		     		dumping_cpu;
	struct kl_pt_regs_ppc64	     	smp_regs[KL_NR_CPUS];
	uint64_t	     		smp_current_task[KL_NR_CPUS];
	uint64_t	     		stack[KL_NR_CPUS];
	uint64_t             		stack_ptr[KL_NR_CPUS];
} __attribute__((packed)) kl_dump_header_ppc64_t;

/* 
 * The following struct is used just to calculate the size needed
 * to store per CPU info. (Make sure it is sync with the above struct)
 */
struct kl_dump_CPU_info_ppc64 {
	struct kl_pt_regs_ppc64		smp_regs;
	uint64_t			smp_current_task;
	uint64_t			stack;
	uint64_t			stack_ptr;
} __attribute__((packed));

/* 
 * Function prototypes
 */
kaddr_t kl_dumpnip_ppc64(kaddr_t tsk);
kaddr_t kl_dumpgpr_ppc64(kaddr_t tsk);
int kl_smp_dumptask_ppc64(kaddr_t tsk);
kaddr_t kl_fix_vaddr_ppc64(kaddr_t, size_t);
kaddr_t kl_kernelstack_ppc64(kaddr_t);
int kl_set_dumparch_ppc64(void);
int kl_vtop_ppc64(kaddr_t, kaddr_t *);
int kl_virtop_ppc64(kaddr_t, void *, kaddr_t *);
int kl_get_dump_header_ppc64(kl_dump_header_ppc64_t *);

#endif /* __KL_DUMP_PPC64_H */
