/*
 * $Id: kl_mem_i386.h,v 1.1 2004/12/21 23:26:21 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __KL_MEM_I386_H
#define __KL_MEM_I386_H

#define KL_KSTACK_SIZE_I386        0x2000ULL
#define KL_PAGE_OFFSET_I386        0xc0000000

#define KL_PAGE_SHIFT_I386         12
#define KL_PAGE_SIZE_I386          (1UL << KL_PAGE_SHIFT_I386)
#define KL_PAGE_MASK_I386          (~(KL_PAGE_SIZE_I386-1))

#define KL_PGDIR_SHIFT_I386        22
#define KL_PGDIR_SIZE_I386         (1UL<<KL_PGDIR_SHIFT_I386)
#define KL_PGDIR_MASK_I386         (~(KL_PGDIR_SIZE_I386-1))
#define KL_PMD_SHIFT_I386          KL_PGDIR_SHIFT_I386
#define KL_PMD_SIZE_I386           KL_PGDIR_SIZE_I386
#define KL_PMD_MASK_I386           KL_PGDIR_MASK_I386

#define KL_PTRS_PER_PGD_I386       1024
#define KL_PTRS_PER_PMD_I386       1
#define KL_PTRS_PER_PTE_I386       1024

/* Used ULL to make masks valid for PAE case, too. */
#define KL_PMD_BASE_MASK_I386      (~((1ULL<<12)-1))
#define KL_PT_BASE_MASK_I386       KL_PMD_BASE_MASK_I386
#define KL_PAGE_BASE_MASK_I386     KL_PMD_BASE_MASK_I386

/* stuff for PSE (page size extension) (4MB pages) */
#define KL_PSE_OFFSET_MASK_I386    ((1UL<<22)-1)
#define KL_PSE_PAGE_MASK_I386      (~KL_PSE_OFFSET_MASK_I386)

/* Definitions for PAE ("36 bit addresses") In fact entries in page
 * dirs and page tables are 64 bit.
 */
#define KL_PGDIR_SHIFT_I386_PAE        30
#define KL_PGDIR_SIZE_I386_PAE         (1ULL<<KL_PGDIR_SHIFT_I386_PAE)
#define KL_PGDIR_MASK_I386_PAE         (~(KL_PGDIR_SIZE_I386_PAE-1))
#define KL_PMD_SHIFT_I386_PAE          21
#define KL_PMD_SIZE_I386_PAE           (1ULL<<KL_PMD_SHIFT_I386_PAE)
#define KL_PMD_MASK_I386_PAE           (~(KL_PMD_SIZE_I386_PAE-1))

#define KL_PTRS_PER_PGD_I386_PAE       4
#define KL_PTRS_PER_PMD_I386_PAE       512
#define KL_PTRS_PER_PTE_I386_PAE       512

/* stuff for PSE (page size extension) with PAE (2MB pages) */
#define KL_PSE_OFFSET_MASK_I386_PAE    ((1ULL<<21)-1)
#define KL_PSE_PAGE_MASK_I386_PAE      (~KL_PSE_OFFSET_MASK_I386_PAE)

/* Flags used in entries of page dirs and page tables. The attributes specified
 * by the settings of those bits refer either to
 *    o single pages -- in case of page table entries,
 *    o page tables (bits 0, 3, 4, 5) or group of pages (bits 1, 2) --
 *      in case of page directory entries,
 * Bit 6 is not used for page dir entries. Bit 7 is only used for page dir
 * entries. Bit 8 has affect only in page table entries.
 * and here are the definitions:
 */
/*      flag                          bit | description  */
#define KL_PAGE_PRESENT_I386  0x001 /* 0  | set: loaded in physical memory
				     *    | clear: not loaded in physical mem */
#define KL_PAGE_RW_I386	      0x002 /* 1  | set: page is writeable
				     *    | clear: not loaded in physical mem */
#define KL_PAGE_USER_I386     0x004 /* 2  | set: user privilege,
				     *    | clear: superviser privilege */
#define KL_PAGE_PWT_I386      0x008 /* 3  | set: write-through caching,
				     *    | clear: write-back caching */
#define KL_PAGE_PCD_I386      0x010 /* 4  | set: caching prevented
				     *    | clear: caching enabled */
#define KL_PAGE_ACCESSED_I386 0x020 /* 5  | set: page has been accessed */
#define KL_PAGE_DIRTY_I386    0x040 /* 6  | set: page has been written to */
#define KL_PAGE_PSE_I386      0x080 /* 7  | set: 4MB (or 2MB for PAE) page size
				     *    | clear: 4KB page size */
#define KL_PAGE_GLOBAL_I386   0x100 /* 8  | set: don't flush pt and pgd entries
				     *    | for this page from TLB */
#define KL_PAGE_PROTNONE_I386 0x080 /* If not present */

#define KL_KERNPG_TABLE_I386 (KL_PAGE_PRESENT_I386 | KL_PAGE_RW_I386 | \
                              KL_PAGE_ACCESSED_I386 | KL_PAGE_DIRTY_I386)

/* pgd/pmd/pte query functions */
#define kl_pmd_none_i386(x) ((x) == 0)
#define kl_pmd_bad_i386(x) (((x) & (~KL_PAGE_MASK_I386 & \
				    ~KL_PAGE_USER_I386)) != \
			    KL_KERNPG_TABLE_I386)

#define kl_pte_none_i386(x) ((uint64_t) (x) == 0ULL)
#define kl_pte_present_i386(x) ((x) & (KL_PAGE_PRESENT_I386 | \
				       KL_PAGE_PROTNONE_I386))

/* functions needed for dump architecture specific memory mapping */
kaddr_t kl_mmap_virtop_i386(
	kaddr_t vaddr   /* kernel virtual address */,
	void *mmp       /* pointer to struct mm_struct */);

kaddr_t kl_kernelstack_i386(kaddr_t task);
kaddr_t kl_fix_vaddr_i386(kaddr_t, size_t);

#endif /* __KL_MEM_I386_H */
