/*
 * $Id: kl_page_ppc64.c,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 * Copyright (C) 2003, 2003 IBM Corporation
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <klib.h>

extern int kl_vtop_ppc64(kaddr_t , kaddr_t *);

#define __bpn_to_ba(x) ((kaddr_t)(x) << KL_PAGE_SHIFT_PPC64)
/*
 * function definitions
 */

/* page table traversal functions */

static kaddr_t
_kl_pgd_offset_ppc64(kaddr_t pgd_base, kaddr_t vaddr)
{
	kaddr_t pgd_off, pmd_base;

	if(LINUX_2_6_X(KL_LINUX_RELEASE)) {
		pgd_off = ((vaddr >> KL_PGDIR_SHIFT_PPC64) & 0x7ff) * 
				KL_NBPW/2;
	} else {
		pgd_off = ((vaddr >> KL_PGDIR_SHIFT_PPC64) &
			(KL_PTRS_PER_PGD_PPC64-1)) * KL_NBPW/2;
	}
	pmd_base = KL_READ_UINT32(pgd_base + pgd_off-KL_PAGE_OFFSET_PPC64);
	return pmd_base;
}

static kaddr_t
_kl_pmd_offset_ppc64(kaddr_t pmd_base, kaddr_t vaddr)
{
	kaddr_t pmd_off, pte_base;

	pmd_off = ((vaddr >> KL_PMD_SHIFT_PPC64)&(KL_PTRS_PER_PMD_PPC64-1)) 
			* KL_NBPW/2;
	pte_base = KL_READ_UINT32(__bpn_to_ba(pmd_base) + pmd_off);
	return pte_base;
}

static kaddr_t
_kl_pte_offset_ppc64(kaddr_t pte_base, kaddr_t vaddr)
{
	kaddr_t pte_off, pte_val;

	pte_off = ((vaddr >> KL_PAGE_SHIFT_PPC64) & (KL_PTRS_PER_PTE_PPC64-1)) 
			* KL_NBPW;
	if(LINUX_2_6_X(KL_LINUX_RELEASE)) {
		pte_base = __bpn_to_ba(pte_base) >> KL_PMD_TO_PTEPAGE_SHIFT_PPC64;
	} else {
		pte_base = __bpn_to_ba(pte_base);
	}
	pte_val = KL_READ_PTR(pte_base + pte_off);
	return pte_val;
}

kaddr_t kl_mmap_virtop_ppc64(kaddr_t vaddr, void *mmp)
{
	kaddr_t pgd_base, pmd_base;
	kaddr_t pte_base, paddr, pte_val;            
	
	/* pgd_offset, pmd_offset, pte_offset is architecture dependent */
	pgd_base = kl_kaddr(mmp, "mm_struct", "pgd");
	pmd_base = _kl_pgd_offset_ppc64(pgd_base, vaddr);
	if (kl_pgd_none_ppc64(pmd_base) || KL_ERROR) {
		KL_ERROR = KLE_INVALID_MAPPING;
		return(0);
	}
	/* get the pmd entry */
	pte_base = _kl_pmd_offset_ppc64(pmd_base, vaddr);
	if (kl_pmd_none_ppc64(pte_base) || KL_ERROR) {
		KL_ERROR = KLE_INVALID_MAPPING;
		return(0);
	}
	vaddr &= ~KL_PGDIR_MASK_PPC64;
	/* get the pte */
	pte_val = _kl_pte_offset_ppc64(pte_base, vaddr);
	if (KL_ERROR || !kl_pte_present_ppc64(pte_val)) {
                KL_ERROR = KLE_INVALID_MAPPING;
                return(0);
	}
	vaddr &= ~KL_PMD_MASK_PPC64;
	/* pte val contains the actual page number */
	paddr = ((pte_val >> KL_PTE_SHIFT_PPC64) << KL_PAGE_SHIFT_PPC64);
	paddr |= (vaddr & ~(KL_PAGE_MASK_PPC64));
	return(paddr);
}
