// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

#include <qfile.h>
#include <qlistbox.h>
#include <qmessagebox.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qfiledialog.h>
#include <qtextedit.h>
#include <qtextstream.h>
#include <qradiobutton.h>
#include <qtextbrowser.h>
#include <qtable.h>
#include <qapplication.h>
#include <qprocess.h>
#include <qfont.h>
#include <qregexp.h>

#include "utils.h"
#include "readmsg.h"
#include "newmsg.h"
#include "addrbook.h"
#include "automark.h"
#include "finddialog.h"
#include "AxForward.h"

#define BLOCK_SIZE 4096

// Classess
extern TMsgProc  *MsgProc;
extern TReadMsg  *ReadMsg;
extern TNewMsg   *NewMsg;
extern TAddrBook *AddrBook;
extern TAutoMark *AutoMark;
//extern FindDialogBase *FindDlg;
extern QApplication *Application;

// Use module
extern TUtils Util;

// Global variables
extern QString  PrgPath;
extern bool  ShowHeaders;
extern TAttrs FormAttrsTb[10];
extern QString  QuotePref;
extern QString ExtEd;
extern QString HTMLV;
extern QString ExtAd;
extern bool  AutoSig;
extern int StatusByte;

FindDialog *FindDlg=NULL;
QProcess *process;



void TMsgProc::MsgListClick(QListViewItem *item)
{
   QString tmp;
   idx_record idx_tmp;
   //QStringList MsgTmp;
  // QListViewItem item (MsgList);
   QListViewItemIterator it (item);
   QTextBrowser *MsgBody = ReadMsg->MsgBody;
   
   Util.Look4Msgs();
   MsgBody->clear();
//   ReadMsg.MsgBody->clear();
   tmp = item->text(0).stripWhiteSpace();
   ReadMsg->setCaption( "Reading message: " + tmp );
   
   idx_tmp = Util.idx_load('i',tmp.toInt());
   
   tmp = PrgPath + "mail/" + tmp;
   
   QStringList *MsgTmp = new QStringList();
  
   QFile fl(tmp);
   if (fl.open(IO_ReadOnly))
   {
     while ( ! fl.atEnd() )
     {
       QTextStream stream (&fl);
       tmp = stream.readLine();
       *MsgTmp += tmp;
     }
     fl.close();
   }

   if ( ShowHeaders )
	   MsgBody->insert( MsgTmp->join("\n"));  //if ( ! MsgTmp->isEmpty() ) 
   else
	   MsgBody->insert( Util.StripHeader(*MsgTmp).join("\n"));  //if ( ! MsgTmp->isEmpty() ) 
     
   ReadMsg->MsgFromEdt->setText( idx_tmp.from );
   ReadMsg->MsgToEdt->setText ( idx_tmp.to_a );
   ReadMsg->MsgAtEdt->setText ( idx_tmp.at );
   ReadMsg->MsgTypeEdt->setText ( idx_tmp.flag );
   ReadMsg->MsgSubjEdt->setText ( idx_tmp.subject );
   ReadMsg->MsgSizeEdt->setText ( idx_tmp.size );
    
    ReadMsg->show();
    ReadMsg->MsgBody->setContentsPos( 0,0);
    delete MsgTmp ;

}


void TMsgProc::UpdateInfo( QListViewItem *item )
{
  QString tmp;
  idx_record idx_tmp;
  
  tmp = item->text(0).stripWhiteSpace();
  idx_tmp = Util.idx_load('i',tmp.toInt());
  
  ToEdt -> setText( idx_tmp.to_a );
  FromEdt -> setText( idx_tmp.from );
  AtEdt -> setText( idx_tmp.at );
  SubjectEdt -> setText( idx_tmp.subject );
     
}

void TMsgProc::UpdateFormAttrs()
{
  QFontInfo fi (MsgList->font());
  QColor font_color(MsgList->foregroundColor());
  QColor background(MsgList->paletteBackgroundColor());
  
  FormAttrsTb[2].FontAttrs.Name      =  fi.family();
  FormAttrsTb[2].FontAttrs.Size      =  fi.pointSize();
  
  FormAttrsTb[2].FontAttrs.Color     =  font_color.name();
  FormAttrsTb[2].FontAttrs.Pitch     =  fi.fixedPitch();
  FormAttrsTb[2].FontAttrs.Bold      =  fi.bold();
  FormAttrsTb[2].FontAttrs.Italic    =  fi.italic();

  FormAttrsTb[2].FormAttrs.Color  =  MsgList->paletteBackgroundColor().name();
  FormAttrsTb[2].FormAttrs.x      =  MsgProc->x();
  FormAttrsTb[2].FormAttrs.y      =  MsgProc->y();
  FormAttrsTb[2].FormAttrs.height =  MsgProc->height();
  FormAttrsTb[2].FormAttrs.width  =  MsgProc->width();
}



void TMsgProc::ColorButtonClick()
{
	QColor colorTmp = QColorDialog::getColor( MsgList->paletteBackgroundColor () );
	if ( colorTmp.isValid() ) MsgList->setPaletteBackgroundColor( colorTmp );
  	UpdateFormAttrs();
}



void TMsgProc::AddTobookBtnClick()
{
   QString tmp;
   QString tst;
   bool found;
   idx_record idx_tmp;
   
   if (MsgList->lastItem() != 0)
   {
       found = FALSE;
       tmp = MsgList->currentItem()->text(0).stripWhiteSpace();
       idx_tmp = Util.idx_load('i',tmp.toInt());
       
       tmp = PrgPath + "conf/Addrbook";
       QFile fl( tmp );
       if ( fl.open( IO_ReadOnly ) )
       {
          QTextStream stream ( &fl );
	  while ( ! stream.atEnd() )
	  {
	    tmp = stream.readLine();
	    tst = tmp.section( ';', 1 ,1 );
	    if (idx_tmp.from == tst ) found = TRUE;
	  }
	  fl.close();
       }
       
       if ( ! found )
       {
         QFile fl( PrgPath + "conf/Addrbook" );
	 if ( fl.open( IO_WriteOnly | IO_Append ) )
	 {
	   QTextStream stream( &fl );
	   tmp = ";" + idx_tmp.from + ";";
	   stream << tmp << endl;
	   fl.close();
	   QMessageBox::information( this, "Addresssbook", "Callsign "+idx_tmp.from+" added to the addressbook" );
	 }
       
       }
       else       
          QMessageBox::information( this, "Addresssbook", "Callsign "+idx_tmp.from+" already in the addressbook" );
       
           
    }   
   
}


void TMsgProc::AddrBookBtnClick()
{
   AddrBook->show();
}



void TMsgProc::Add2MarkBtnClick()
{
    QString tmp;
    idx_record idx_tmp;
    
    AutoMark->show();
    tmp = MsgList->currentItem()->text(0).stripWhiteSpace();
    idx_tmp = Util.idx_load('i',tmp.toInt() );
    AutoMark->AutoMarkTbl->setText( AutoMark->AutoMarkTbl->numRows()-1,0,idx_tmp.to_a);
}


void TMsgProc::ArchiveBtnClick()
{
   QString tmp,ttp;
//    char *data = new char[BLOCK_SIZE];
   
   ttp = MsgList->currentItem()->text(0).stripWhiteSpace();
   tmp = MsgList->currentItem()->text(8);
   
   QString s = QFileDialog::getSaveFileName(
                    PrgPath+"/"+tmp,
                    "Text files (*.txt)",
                    this,
                    tmp.replace( QRegExp(
                    "[^"
                    "A-Z,a-z,0-9,"
                    "\\^,\\&,\\',\\@,"
                    "\\{,\\},\\[,\\],"
                    "\\,,\\$,\\=,\\!,"
                    "\\-,\\#,\\(,\\),"
                    "\\%,\\.,\\+,\\~,\\_"
                    "]"), " " ),
                    "Enter file name" );

   if ( ! s.isEmpty() ) Util.CopyFile( PrgPath + "mail/" + ttp, s );
}



void TMsgProc::CommentBtnClick()
{
   QString tmp;
   idx_record idx_tmp;
   
    if (MsgList->lastItem() != 0)
    {
       NewMsg->EditMsg->clear();
       tmp = MsgList->currentItem()->text(0).stripWhiteSpace();
       idx_tmp = Util.idx_load('i',tmp.toInt());
       tmp = PrgPath + "mail/" + tmp;
       
       NewMsg->EditMsg->insertParagraph( "" , -1);
       NewMsg->EditMsg->insertParagraph( "Quoting form a previous message ..." , -1);
       
 //QMessageBox::information( this, "Title", tmp );
       
       QStringList *MsgTmp = new QStringList();
       
       QFile fl( tmp);
       
       if (fl.open( IO_ReadOnly ))
       {
         QTextStream stream ( &fl );
	 while ( ! stream.atEnd() )
	 {
	   tmp = stream.readLine();
           *MsgTmp += tmp;
	 }
       }
       
       if ( ShowHeaders )
          NewMsg->EditMsg->setText( MsgTmp->join("\n") );
       else
          NewMsg->EditMsg->setText( Util.StripHeader( *MsgTmp ).join("\n") );

     for (int i = 0; i<=NewMsg->EditMsg->lines(); i++) NewMsg->EditMsg->insertAt( QuotePref + " ",i,0);
         
     delete MsgTmp;     
   
    if (idx_tmp.flag == "P" || idx_tmp.flag == "W" || idx_tmp.flag == "F" )
    {
      NewMsg->ToEdt->setText( idx_tmp.to_a );
      NewMsg->SubjEdt->setText( "Re: " + idx_tmp.subject );
      NewMsg->AtEdt->setText( "" );
      NewMsg->MsgTypeP->setChecked( TRUE );
      NewMsg->MsgTypeB->setChecked( FALSE );
    }
    
    if ( idx_tmp.flag == "B" || idx_tmp.flag == "V" || idx_tmp.flag == "G" )
    {
      NewMsg->ToEdt->setText( idx_tmp.to_a );
      NewMsg->SubjEdt->setText( "Re: " + idx_tmp.subject );
      NewMsg->AtEdt->setText( idx_tmp.at );
      NewMsg->MsgTypeP->setChecked( FALSE );
      NewMsg->MsgTypeB->setChecked( TRUE );
    }
    
    NewMsg->show();
  }
}


void TMsgProc::EditBtnClick()
{
    QString tmp;
    idx_record idx_tmp;
   
    if (MsgList->lastItem() != 0)
    {
	    EditBtn->setEnabled( FALSE );
       NewMsg->EditMsg->clear();
       tmp = MsgList->currentItem()->text(0).stripWhiteSpace();
       idx_tmp = Util.idx_load('i',tmp.toInt());
       tmp = PrgPath + "mail/" + tmp;
       
       QFile fl( tmp ); 
       if ( fl.open( IO_ReadOnly ) ) 
       {
          QTextStream stream( &fl );
          NewMsg->EditMsg->setText( stream.read() );
	  fl.close();
       }
       
       NewMsg->ToEdt->setText( idx_tmp.to_a );
       NewMsg->SubjEdt->setText( idx_tmp.subject );
       NewMsg->AtEdt->setText( idx_tmp.at );
       NewMsg->show();
       if (idx_tmp.flag == "P" || idx_tmp.flag == "W" || idx_tmp.flag == "F" ) 
         NewMsg->MsgTypeP->setChecked( TRUE ); else NewMsg->MsgTypeB->setChecked( TRUE );
    }
}


void TMsgProc::ExtEditBtnClick()
{
   QString tmp;
   
   if (MsgList->childCount() > 0)
   {
     if ( ! ExtEd.isEmpty() )
     {
       process = new QProcess(this);
       process->addArgument( ExtEd );
       process->addArgument( PrgPath + "mail/" + MsgList->currentItem()->text(0).stripWhiteSpace() );
               
//       connect( process, SIGNAL(processExited ()), this, SLOT(ExtEdtExited()) );

        if ( !process->start() ) 
            QMessageBox::critical( this, "Error", "External text editor cannot be executed" );

     }
    }
   
   
}


void TMsgProc::ForwardBtnClick()
{
	TAxForward ForwardMsgs;
	
	if (StatusByte==0 && Util.Look4Idx('q')>=1)
	{
		StatusByte = 5;
		ForwardMsgs.run();
		while (ForwardMsgs.running() )
			Application->processEvents();
		Util.GetList();
		Util.MsgDir( TRUE );
	}
	StatusByte = 0;

}


void TMsgProc::FontButtonClick()
{

    MsgList->setFont( QFontDialog::getFont( 0, MsgList->font() ) );
    UpdateFormAttrs();
}


void TMsgProc::HTMLBtnClick()
{
  QString tmp;

  if (MsgList->childCount() > 0)
  {
       tmp = PrgPath + "mail/" + MsgList->currentItem()->text(0).stripWhiteSpace();
       
       QFile flIn( tmp);
       if (flIn.open( IO_ReadOnly ))
       {
	 QFile flOut(tmp+".html");
	 flOut.open( IO_WriteOnly );
         
	 QTextStream streamIn  ( &flIn );
         QTextStream streamOut ( &flOut );
	 	 
	 while ( ! streamIn.atEnd() )
	 {
	   tmp = streamIn.readLine();
           if ( ! Util.HeaderLine( tmp ) ) streamOut << tmp;   
	 }
	 flIn.close();
	 flOut.close();
       }
     
       if ( ! HTMLV.isEmpty() )
       {
         process = new QProcess(this);
         process->addArgument( HTMLV );
         process->addArgument( PrgPath + "mail/" + MsgList->currentItem()->text(0).stripWhiteSpace() + ".html" );
               
//       connect( process, SIGNAL(processExited ()), this, SLOT(ExtEdtExited()) );

        if ( !process->start() ) 
            QMessageBox::critical( this, "Error", "External text editor cannot be executed" );

       }
     
  }
}


void TMsgProc::KillButtonClick()
{
    QString msg_nr;
    QString tmp;
    QListViewItem *current (MsgList->currentItem() );
    QListViewItemIterator it (MsgList->currentItem() );
    //QListViewItem *next (MsgList->currentItem()->itemBelow() );
    
    if (MsgList->lastItem() != 0)
    {
      current =  MsgList->currentItem();
      msg_nr = current->text(0).stripWhiteSpace();
      
//      QMessageBox::information( this, "Title", "nr " + next->text(0) );
      
      tmp = PrgPath + "mail/" + msg_nr;
      QFile::remove( tmp );
            
      tmp = PrgPath + "queue/" + msg_nr + ".idx";
      if (QFile::exists( tmp )) QFile::remove( tmp );
      
      delete MsgList->currentItem();
     // MsgList->setCurrentItem( current->itemAbove() );
          
      Util.MsgDir( FALSE );

      MsgList->setCurrentItem( *(it) );
      MsgList->currentItem()->setSelected( TRUE );
      //MsgList->ensureItemVisible( *it );
    }
}


void TMsgProc::Msg2PrgBtnClick()
{
   QString tmp;
   
   if (MsgList->childCount() > 0)
   {
     if ( ! ExtAd.isEmpty() )
     {
       process = new QProcess(this);
       process->addArgument( ExtAd );
       process->addArgument( PrgPath + "mail/" + MsgList->currentItem()->text(0).stripWhiteSpace() );
               
//       connect( process, SIGNAL(processExited ()), this, SLOT(ExtEdtExited()) );

        if ( !process->start() ) 
            QMessageBox::critical( this, "Error", "External text editor cannot be executed" );

     }
    }
  
}


void TMsgProc::MsgAttrsBtnClick()
{

}


void TMsgProc::NewMsgBtnClick()
{
	NewMsg->MsgTypeP->setChecked( FALSE );
	NewMsg->MsgTypeB->setChecked( FALSE );
	NewMsg->EditMsg->clear();
	NewMsg->ToEdt->setText( "" );
	NewMsg->SubjEdt->setText( "" );
	NewMsg->AtEdt->setText( "" );

	QDate date = QDate::currentDate();
	QTime time = QTime::currentTime();
	QString s;
	s.sprintf("  ->  %02d-%02d-%02d  %02d:%02d  <-",date.day(),date.month(),date.year(),time.hour(),time.minute() );
	NewMsg->EditMsg->append( s );


	if (AutoSig )
	{ 
		NewMsg->EditMsg->append( "\n" );
		NewMsg->EditMsg->append( "\n" );
		NewMsg->EditMsg->append( "[Signature]" );
	}

  NewMsg->show();

}


void TMsgProc::OptionsBtnClick()
{

}


void TMsgProc::PrintBtnClick()
{

}


void TMsgProc::RefreshBtnClick()
{
   Util.MsgDir( TRUE );
}


void TMsgProc::ReplyBtnClick()
{
   QString tmp;
   idx_record idx_tmp;
   
    if (MsgList->lastItem() != 0)
    {
       NewMsg->EditMsg->clear();
       tmp = MsgList->currentItem()->text(0).stripWhiteSpace();
       idx_tmp = Util.idx_load('i',tmp.toInt());
       tmp = PrgPath + "mail/" + tmp;
       
       NewMsg->EditMsg->insertParagraph( "" , -1);
       NewMsg->EditMsg->insertParagraph( "Quoting form a previous message ..." , -1);
       
 //QMessageBox::information( this, "Title", tmp );
       
       QStringList *MsgTmp = new QStringList();
       
       QFile fl( tmp);
       
       if (fl.open( IO_ReadOnly ))
       {
         QTextStream stream ( &fl );
	 while ( ! stream.atEnd() )
	 {
	   tmp = stream.readLine();
           *MsgTmp += tmp;
	 }
       }
       
       if ( ShowHeaders )
          NewMsg->EditMsg->setText( MsgTmp->join("\n") );
       else
          NewMsg->EditMsg->setText( Util.StripHeader( *MsgTmp ).join("\n") );

     for (int i = 0; i<=NewMsg->EditMsg->lines(); i++) NewMsg->EditMsg->insertAt( QuotePref + " ",i,0);
         
     delete MsgTmp;      
   
    if (idx_tmp.flag == "P" || idx_tmp.flag == "W")
    {
      NewMsg->ToEdt->setText( idx_tmp.from );
      NewMsg->SubjEdt->setText( idx_tmp.subject );
      NewMsg->AtEdt->setText( "" );
      NewMsg->MsgTypeP->setChecked( TRUE );
      NewMsg->MsgTypeB->setChecked( FALSE );
    }
    
    if ( idx_tmp.flag == "B" || idx_tmp.flag == "V" || idx_tmp.flag == "G" )
    {
      NewMsg->ToEdt->setText( idx_tmp.to_a );
      NewMsg->SubjEdt->setText( "Re: " + idx_tmp.subject );
      NewMsg->AtEdt->setText( idx_tmp.at );
      NewMsg->MsgTypeP->setChecked( FALSE );
      NewMsg->MsgTypeB->setChecked( TRUE );
    }
    
    NewMsg->show();
  }
}


void TMsgProc::SaveMsgBtnClick()
{
   QString tmp,ttp;
 //  char *data = new char[BLOCK_SIZE];
   
   ttp = MsgList->currentItem()->text(0).stripWhiteSpace();
   tmp = MsgList->currentItem()->text(8);
   
   QString s = QFileDialog::getSaveFileName(
                    PrgPath+"/"+tmp,
                    "Text files (*.txt)",
                    this,
                    tmp.replace( QRegExp(
                    "[^"
                    "A-Z,a-z,0-9,"
                    "\\^,\\&,\\',\\@,"
                    "\\{,\\},\\[,\\],"
                    "\\,,\\$,\\=,\\!,"
                    "\\-,\\#,\\(,\\),"
                    "\\%,\\.,\\+,\\~,\\_"
                    "]"), " " ),
                    "Choose a file" );

   
   QStringList *MsgTmp = new QStringList();
   
   QFile f_from ( PrgPath + "mail/" + ttp );
   if ( f_from.open( IO_ReadOnly ) )
   {
      QTextStream stream ( &f_from );
      
      while ( ! stream.atEnd() )
      {
        tmp = stream.readLine();
        *MsgTmp += tmp;
      }
      f_from.close();
   }
      
   QStringList *MsgTmp2 = new QStringList();
   *MsgTmp2 = Util.StripHeader( *MsgTmp ).join("\n");

   QFile f_to ( s );
   if ( f_to.open( IO_WriteOnly ))
   {
     QTextStream stream ( &f_to );
     QStringList::Iterator it; 
     
     for (it = MsgTmp2->begin(); it != MsgTmp2->end();++it)
     {
       stream << *it;
     }
     f_to.close();
   }  
   
   delete MsgTmp;
   delete MsgTmp2;
   
}


void TMsgProc::TextSearchBtnClick()
{
 
    FindDlg = new FindDialog( this );
    connect(FindDlg, SIGNAL(findtext(const QString&,bool,bool )), this, SLOT(findNext(const QString&, bool, bool)));

    FindDlg->show();
    FindDlg->raise();
    FindDlg->setActiveWindow();
}


void TMsgProc::findNext( const QString &text, bool dir, bool casesens )
{
//QMessageBox::information( this, "Title", text );
  
  QListViewItem *i;
  QListViewItemIterator it ( MsgList->currentItem() );
  
  QString tmp;
  bool found=FALSE;
  
  for (; it.current() && ! found; dir ? ++it : --it )
  {
    if (! MsgList->isSelected(MsgList->currentItem()))
    {
      it = QListViewItemIterator(MsgList->firstChild());
      MsgList->setSelected( *it, TRUE );
    }
    i = *it;
    tmp = PrgPath + "mail/" + i->text(0).stripWhiteSpace();
    
    found = FALSE;

    QFile fl( tmp);
    if (fl.open( IO_ReadOnly ))
    {
       QTextStream stream ( &fl );
       while ( ! stream.atEnd() )
       {
         tmp = stream.readLine();
         if (tmp.find(text,0,casesens) != -1 ) found = TRUE; //else found = FALSE;
       }
    }
  } 
  
  if (found)
    if (dir) it--; else it++;
  else 
     QMessageBox::information( this, "Text Search", text + " has not been found !" );
     
  MsgList->setCurrentItem( *it );
  MsgList->ensureItemVisible( *it );
  
  FindDlg->hide();
  delete FindDlg;
}


void TMsgProc::UpBtnClick()
{
  QListViewItemIterator it (MsgList->currentItem() );
  MsgList->setCurrentItem( *(--it) );
}


void TMsgProc::DownBtnClick()
{
  QListViewItemIterator it (MsgList->currentItem() );
  MsgList->setCurrentItem( *(++it) );
}




void TMsgProc::hideEvent( QHideEvent *e )
{

  if ( ! e->spontaneous ()  )    UpdateFormAttrs();
}





void TMsgProc::showEvent( QShowEvent * e )
{
  if ( ! e->spontaneous ()  )
  {
  QFont fi;
  QColor color; //(MsgList->paletteBackgroundColor());
  
  
  fi.setFamily(FormAttrsTb[2].FontAttrs.Name);
  fi.setPointSize(FormAttrsTb[2].FontAttrs.Size);
  
  fi.setFixedPitch(FormAttrsTb[2].FontAttrs.Pitch);
  fi.setBold(FormAttrsTb[2].FontAttrs.Bold);
  fi.setItalic(FormAttrsTb[2].FontAttrs.Italic);
  MsgList->setFont( fi );

  color.setNamedColor(FormAttrsTb[2].FormAttrs.Color);
  MsgList->setPaletteBackgroundColor(color);
  MsgList->setPaletteForegroundColor (FormAttrsTb[2].FontAttrs.Color); // Font Color
  
  move( FormAttrsTb[2].FormAttrs.x, FormAttrsTb[2].FormAttrs.y );
  resize( FormAttrsTb[2].FormAttrs.width, FormAttrsTb[2].FormAttrs.height );
  }
}


void TMsgProc::addFROM2AB()
{
	QString tmp,tst;
	int k;
	idx_record idx_tmp;
//	QListViewItem * item = MsgList->currentItem();
	QTable * AB = AddrBook->AddrList;
	
	AddrBook->show();
	int i = AB->numRows();
	tmp = MsgList->currentItem()->text(0).stripWhiteSpace();
	idx_tmp = Util.idx_load('i',tmp.toInt() );
	AB->insertRows(i,1);
	
	// Must parse whole message to find "FROM: SP9UMX@SR9ZAA.#KRA.POL.EU (Janusz)"
	tmp = PrgPath + "mail/" + tmp;
	QFile fl( tmp );
	if ( fl.open( IO_ReadOnly ) )
	{
		QTextStream stream ( &fl );
		while ( ! stream.atEnd() )
		{
			tmp = stream.readLine();
			if ((tmp.find("FROM: "+idx_tmp.from.stripWhiteSpace(),0,FALSE)) == 0 ) // find "FROM :"
			{
				tst = tmp.remove(0,6).stripWhiteSpace();
				if ( (tst.find('@',0,FALSE)) > 0 ) 
					AB->setText(i,1,tst.section('@',0,0).stripWhiteSpace());
					tst = tst.remove(0,tst.find('@',0,FALSE)+1);
					k = tst.find('(',0,FALSE);
					if ( k>0 )
					{
						AB->setText(i,2,tst.section('(',0,0).stripWhiteSpace());
						tst = tst.remove(0,k+1);
						AB->setText(i,0,tst.section(')',0,0).stripWhiteSpace());
					}
					else
					{
						AB->setText(i,2,tst.stripWhiteSpace());
					}
			}
			else
				AB->setText(i, 1, idx_tmp.from);
		}
	}
}


void TMsgProc::contextMenu( QListViewItem * , const QPoint & , int )
{
	QPopupMenu* contextMenu = new QPopupMenu( this );
	Q_CHECK_PTR( contextMenu );
	QLabel *caption = new QLabel( "Message actions", this );
	caption->setAlignment( Qt::AlignCenter );
	contextMenu->insertItem( caption );
	contextMenu->insertSeparator();
	contextMenu->insertItem( "Add the author to AddressBook",  this, SLOT(addFROM2AB()) );
	contextMenu->insertItem( "Kill Message",  this, SLOT(KillButtonClick()));
/*	contextMenu->insertItem( "Add &FROM to AutoMark",  this, SLOT(addFROM2AMark()), CTRL+Key_F );
	contextMenu->insertItem( "Add &BBS to AutoMark",  this, SLOT(addBBS2AMark()), CTRL+Key_B );*/
	contextMenu->insertSeparator();
	contextMenu->insertItem( "Change Background color",  this, SLOT(ColorButtonClick()) );
	contextMenu->insertItem( "Change font",  this, SLOT(FontButtonClick()) );
	contextMenu->exec( QCursor::pos() );
	delete contextMenu;
}
