/* -*- mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/** \file examples/echelon.C
\brief Echelon form of matrix over  Zp.
 \ingroup examples
*/

#include <iostream>

#include "linbox/field/modular-double.h"
#include "linbox/util/matrix-stream.h"
#include "linbox/algorithms/echelon-form.h"

using namespace LinBox;
using namespace std;

int main (int argc, char **argv)
{
	if (argc < 3 || argc > 3) {
		cerr << "Usage: echelon <matrix-file-in-SMS-format> <p>" << endl;
		return -1;
	}
	ifstream input (argv[1]);
	if (!input) { cerr << "Error opening matrix file " << argv[1] << endl; return -1; }
	
	typedef Modular<double> Field;
	double q = atof(argv[2]);
	Field F(q);

	MatrixStream<Field> ms(F,input);
	BlasMatrix<Field::Element> A(ms);
	BlasMatrix<Field::Element> E(A.rowdim(),A.coldim());
	cout << "A is " << A.rowdim() << " by " << A.coldim() << endl;

	EchelonFormDomain<Modular<double> > EFD (F);

	EFD.rowReducedEchelon(E,A);

	if (E.coldim() <20)
		E.write(cerr<<"Echelon = "<<endl,F)<<endl;

	return 0;
}
