#ifndef _LCS_SRV_DEF
#define _LCS_SRV_DEF

/* Switches to control compilation of different versions: */

#include "../config.h"

/* if linesrv shouldn't become a daemon: */
//#define STAY_TTY
//#define DEBUG
//#define TPUT_DEBUG

// PAM / Crypt gets now automatically handled by configure!

/*---------*/
/* other settings + definitions */

#define LCS_LOGNAME		"linesrv"	// use syslog as %s
#define LCS_PAM_SERVICE		"linecontrol"
#define LCS_PAM_SHUTDOWN_SERVICE "lcshutdown"
#define LCS_MYSQL_DEFGROUP	"linecontrol"
#define SHADOW_PWD_FILE		"/etc/shadow"

#define LCS_KICK_MSG		"You're client did unusual things... bye."
#define LCS_LITTLE_LOOP		3	// secs timeout for the select() call
#define LCS_BIG_LOOP		10	// don't big-loop more than every # sec
#define LCS_TIME_FAILED		10	// if loop had more than # secs
					// system-time has been changed.
					// update all time-vars (avoid kicks
					// and bad online-times)
#define LCS_WAITCON_GAP		2	// sleep for #secs, then check con again
#define LCS_ACTIVITY		2	// for throughput measurement

#define LCS_VERSION_STR		VERSION
#define LCS_NAME		"LineControl Server"
#define LCS_COPY		"by S. Fuchs 1999-2002"
#define LCS_CPR			"(c) by S. Fuchs 1999-2002"

/* for the pinger */
#define LCS_PING_MAXDATA	500
#define LCS_PING_DATA		60
#define LCS_PING_INTERVAL	120
#define LCS_PING_MININTERVAL	11

/* MySQL defaults */
#define LCS_DB_PORT 3306

/* possible status of client */
/* now defined in lcp3.h CLT_* */

/* type of IP - List */
#define IPL_INVALID	0
#define IPL_ALLOW	1
#define IPL_DENY	2
/* type field of ipl_item_t! */
#define IPL_RANGE	0
#define IPL_MASK	1

/* for struct con_action_t.doing */
#define DOING_NOTHING	0
#define DOING_OPENING	1
#define DOING_CLOSING	2
//#define DOING_FAILURE	3

/* for server->con_type */
#define CT_NETDEV	0	// [ net device (e.g. ppp0) ] --> default
#define CT_ISDN		1	// [ /dev/isdninfo ]
#define CT_FILE		2	// [ some file, server->con_status_file ]
#define CT_NUM_KEYS	3	// number of available CT_* keys

/* DC/LC mixup */
#define LCS_CLT_DC	1	// DialControl client using udp, proto 2.0
#define LCS_CLT_LC	2	// LineControl client using tcp, proto 2.0
#define LCS_CLT_LCP3	3	// LineControl client TCP, proto ver 3.1
#define LCS_CLT_UNKNOWN_TCP 4	// either LCC proto 2.0 or LCC proto 3.0

/* connection mixup, see 'netinput.c: get_data(...)' */
#define SOCK_TYPE_NONE	0
#define SOCK_TYPE_UDP	1
#define SOCK_TYPE_TCP	2

/* ISDN - Watcher */
#define LCS_CALLERLINE 		1
#define LCS_RECEIVERLINE 	2
// ISDN Watcher config defaults
#define LCS_CALLER_NR_POS 	0
#define LCS_RECEIVER_NR_POS	0
#define LCS_MONTH_POS		0
#define LCS_DAY_POS		0
#define LCS_TIME_POS		0

#endif /* _LCS_SRV_DEF */
