/* $Id: gtkcellrendererspin.h,v 1.2 2005/03/24 10:27:25 marcusva Exp $
 * GtkCellRendererSpin
 * Copyright (C) 2004-2005 Marcus von Appen
 * Copyright (C) 2004 Lorenzo Gil Sanchez
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef GTK_CELL_RENDERER_SPIN_H
#define GTK_CELL_RENDERER_SPIN_H

#include <gtk/gtkcellrenderertext.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_RENDERER_SPIN (gtk_cell_renderer_spin_get_type ())
#define GTK_CELL_RENDERER_SPIN(obj) (G_TYPE_CHECK_INSTANCE_CAST \
                                     ((obj), GTK_TYPE_CELL_RENDERER_SPIN, \
                                      GtkCellRendererSpin))
#define GTK_CELL_RENDERER_SPIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST \
                                             ((klass), \
                                              GTK_TYPE_CELL_RENDERER_SPIN, \
                                              GtkCellRendererSpinClass))
#define GTK_IS_CELL_RENDERER_SPIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE \
                                        ((obj), GTK_TYPE_CELL_RENDERER_SPIN))
#define GTK_IS_CELL_RENDERER_SPIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE \
                                                ((klass), \
                                                 GTK_TYPE_CELL_RENDERER_SPIN))
#define GTK_CELL_RENDERER_SPIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS \
                                               ((obj), \
                                                GTK_TYPE_CELL_RENDERER_SPIN, \
                                                GtkCellRendererTextClass))
						 
typedef struct _GtkCellRendererSpin GtkCellRendererSpin;
typedef struct _GtkCellRendererSpinClass GtkCellRendererSpinClass;

struct _GtkCellRendererSpin
{
     GtkCellRendererText parent;

     /* <private> */
     gdouble min;
     gdouble max;
     gdouble step;
};

struct _GtkCellRendererSpinClass
{
     GtkCellRendererTextClass parent;
};

GType gtk_cell_renderer_spin_get_type (void);
GtkCellRenderer *gtk_cell_renderer_spin_new (void);
GtkCellRenderer *gtk_cell_renderer_spin_new_with_range  (gdouble min,
                                                         gdouble max,
                                                         gdouble step);
void gtk_cell_renderer_spin_set_range (GtkCellRendererSpin *renderer,
                                       gdouble min, gdouble max);
void gtk_cell_renderer_spin_get_range (GtkCellRendererSpin *renderer,
                                       gdouble *min, gdouble *max);

G_END_DECLS

#endif
