/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441Send.h"
#include "FSK441CardReceive.h"

#include "FSK441Controller.h"

CFSK441Controller::CFSK441Controller(CSoundDev* soundDev, CPTTPort* pttPort) :
CController(soundDev, pttPort),
m_singleTone(false)
{
	wxASSERT(soundDev != NULL);
	wxASSERT(pttPort != NULL);
}

CFSK441Controller::~CFSK441Controller()
{
}

CSend* CFSK441Controller::createSendThread(CSoundDev* soundDev, CPTTPort* pttPort)
{
	CSend* send = new CFSK441Send(soundDev, pttPort);

	send->Create();
	send->Run();
	send->Pause();

	return send;
}

CReceive* CFSK441Controller::createReceiveThread(CSoundDev* soundDev)
{
	CReceive* receive = new CFSK441CardReceive(soundDev);

	receive->Create();
	receive->Run();
	receive->Pause();

	return receive;
}

void CFSK441Controller::setSingleTone(bool singleTone)
{
	getMutex().Lock();
	m_singleTone = singleTone;
	getMutex().Unlock();
}

void CFSK441Controller::setLocal()
{
	CFSK441Receive* receive1 = dynamic_cast<CFSK441Receive*>(getReceive1());
	receive1->setSingleTone(m_singleTone);

	CFSK441Receive* receive2 = dynamic_cast<CFSK441Receive*>(getReceive2());
	receive2->setSingleTone(m_singleTone);
}
