/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44MessageBase_H
#define	JT44MessageBase_H

#include <wx/wx.h>

#include "common/Average.h"

class CJT44MessageBase {

    public:
	virtual ~CJT44MessageBase();

	virtual double   getData(int letter, int pos) const;
	virtual double   getSync(int pos) const;
	virtual double   getNoise(int pos) const;

	virtual int      getQuality() const;
	virtual double   getStrength() const;

	virtual wxString getText() const;
	virtual wxString getOddEvenText() const;
	virtual wxString getLast4Text() const;

    protected:
	CJT44MessageBase();

	void clearData();
	void clearSync();
	void clearNoise();

	void addData(int letter, int pos, double val);
	void addSync(int pos, double val);
	void addNoise(int pos, double val);

	void subtractData(int letter, int pos, double val);
	void subtractSync(int pos, double val);
	void subtractNoise(int pos, double val);

    private:
	CAverage* m_data;
	CAverage* m_sync;
	CAverage* m_noise;

	int getSymbolsIndex(int letter, int pos) const;
	int getOddEvenSymbolsIndex(int letter, int pos) const;
	int getLast4SymbolsIndex(int letter, int pos) const;

	double getSymbolCorrelation(int symbol, int pos) const;
	double getOddEvenSymbolCorrelation(int symbol, int pos) const;
	double getLast4SymbolCorrelation(int pos) const;
};

#endif
