package Lire::AsciiDlf::Summary;

use strict;

use vars qw( $VERSION @ISA );

use Lire::Summary;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.3 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::Summary );
}

sub init_report {
    my $self = shift;

    $self->{data} = [];
    my $i = 0;
    foreach my $op ( @{$self->{ops}}) {
	$op->init_report( @_ );
	$self->{data}[$i++] = $op->init_group_data();
    }

    $self;
}

sub update_report {
    my ( $self, $dlf ) = @_;

    my $i = 0;
    foreach my $op ( @{$self->ops} ) {
	$op->update_group_data( $dlf, $self->{data}[$i++] );
    }

    $self;
}

sub end_report {
    my ( $self ) = @_;

    my $i = 0;
    foreach my $op ( @{$self->ops} ) {
	$op->end_group_data( $self->{data}[$i++] );
    }

    $self;
}

sub write_report {
    my ( $self, $fh, $prefix ) = @_;
    $fh	    ||= \*STDOUT;
    $prefix ||= 0;

    my $pfx = ' ' x $prefix;

    # FIXME: This needs to be updated to something more sensible
    # in the presentation upgrade.
    my $i = 0;
    foreach my $op ( @{$self->{ops}} ) {
	print $fh $pfx, "<lire:entry>\n";
	print $fh $pfx, " <lire:name>", ucfirst $op->name, "</lire:name>\n";
	print $fh $pfx, " <lire:value/>\n" 
	  if UNIVERSAL::isa( $op, "Lire::Group" );
	$op->write_group_data( $fh, $prefix + 1, $self->{data}[$i++] );
	print $fh $pfx, "</lire:entry>\n";
    }

    $self;
}


# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::AsciiDlf::Summary -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: Summary.pm,v 1.3 2002/02/03 21:56:43 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
