package Lire::Config;

use strict;

use vars qw( $VERSION $PACKAGE $prefix $sysconfdir $exec_prefix $pkgdatadir
	     $datadir $libexecdir
	     $xsldir $dsssldir $filterdir $reportdir $schemadir $descriptiondir
	     $convert
	    );

BEGIN {
    no strict 'refs'; # So that things like ${prefix}/etc works

    ($VERSION)	= '$Release$' =~ m!Release: ([.\d]+)!;

    $PACKAGE	    = "lire";
    $prefix	    = "/home/francis/tests/lire-unstable";
    $sysconfdir	    = "${prefix}/etc";
    $exec_prefix    = "${prefix}";
    $datadir	    = "${prefix}/share";
    $pkgdatadir	    = "${prefix}/share/lire";
    $libexecdir	    = "${exec_prefix}/libexec";

    $dsssldir	    = "$pkgdatadir/xml/stylesheet/dsssl";
    $xsldir	    = "$pkgdatadir/xml/stylesheet/xsl";

    $schemadir	    = "$pkgdatadir/schemas";
    $reportdir	    = "$pkgdatadir/reports";
    $filterdir	    = "$pkgdatadir/filters";
    $descriptiondir = "$pkgdatadir/descriptions";

    $convert	    = "/usr/bin/convert";
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Config - import configure variables to perl

=head1 SYNOPSIS

 use Lire::Config;

=head1 DESCRIPTION

Lire::Config sets perl variables like I<$prefix>, I<$dsssldir>, I<$reportdir>
and I<$convert> to their ./configure equivalents (/home/francis/tests/lire-unstable, /usr/bin/convert
etc.)  This allows us to convert only this file from Config.pm.in to Config.pm;
no need to convert B<all> perl scripts during configure.

=head1 SEE ALSO

/usr/share/autoconf/INSTALL, autoconf(1), The Autobook by David MacKenzie

=head1 VERSION

$Id: Config.pm.in,v 1.8 2002/01/19 00:35:07 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut

# Local Variables:
# mode: cperl
# End:
