<?xml version="1.0"?>
<!--  Note:  exclude-result-prefixes isn't supported by sablotron -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lire="http://www.logreport.org/LRML/"
  exclude-result-prefixes="lire">

  <xsl:import href="config.xsl"/>

  <xsl:param name="linewidth" select="30"/>
                
  <xsl:output method="xml" omit-xml-declaration="no" indent="yes"
    doctype-public="-//OASIS//DTD DocBook XML V4.1.2//EN"
    doctype-system="http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd"/>

  <xsl:template match="/lire:report">
    <article>
      <title>Lire <xsl:value-of select="lire:section/lire:subreport/@superservice"/> Report</title>

      <xsl:if test="timespan">
        <para>
          <xsl:text>This report is based on data from a log file, generated during </xsl:text>
          <xsl:value-of select="lire:timespan"/>
          <xsl:text>.</xsl:text>
        </para>
      </xsl:if>
      <xsl:apply-templates select="lire:section"/>
    </article>
  </xsl:template>

  <xsl:template match="lire:section">
    <sect1>
      <title>
        <xsl:value-of select="lire:title"/>
      </title>
      <xsl:if test="lire:description">
	<xsl:apply-templates select="lire:description"/>
      </xsl:if>
      <xsl:apply-templates select="lire:subreport"/>
    </sect1>
  </xsl:template>
  
  <xsl:template match="lire:subreport">
    <sect2 id="{generate-id(.)}">
      <title>
        <xsl:value-of select="lire:title"/>
      </title>
      <xsl:if test="lire:description">
	<xsl:if test="$debug">
	  <xsl:message>target-user=<xsl:value-of select="$target-user"/></xsl:message>
	</xsl:if>

	<xsl:variable name="descs" select="lire:description"/>
    
	<xsl:choose>
	  <!-- Try to find a description with the specified target-user -->
	  <xsl:when test="count($descs[@target-user = $target-user])">
	    <xsl:apply-templates select="$descs[@target-user = $target-user][1]"/>
	  </xsl:when>

	  <!-- Otherwise print the first one -->
	  <xsl:otherwise>
	    <xsl:apply-templates select="$descs[1]"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:if>
      <xsl:apply-templates select="lire:image"/>
      <xsl:apply-templates select="lire:table"/>
    </sect2>
  </xsl:template>

  <xsl:template match="lire:description">
    <xsl:if test="$debug">
      <xsl:message>userlevel=<xsl:value-of select="$userlevel"/></xsl:message>
    </xsl:if>

    <xsl:choose>
      <xsl:when test="$userlevel = 'advanced'">
	<xsl:apply-templates mode="docbook.advanced"/>	  
      </xsl:when>
      <xsl:otherwise>
	<xsl:apply-templates mode="docbook.normal"/>	  
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*" mode="docbook.normal">
    <xsl:choose>
      <xsl:when test="@userlevel">
      <!-- Copy only of userlevel is normal -->
	<xsl:if test="@userlevel = 'normal'">
	  <xsl:copy-of select="."/>
	</xsl:if>
      </xsl:when>

      <!-- No userlevel attribute : copy -->
      <xsl:otherwise>
	<xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*" mode="docbook.advanced">
    <!-- Copy all elements -->
    <xsl:copy-of select="."/>
  </xsl:template>

  <!-- INVARIANT: We assume that the nesting of lire:group is equal 
  in all lire:entry. That is if we have one lire:group in the first
  lire:entry, all lire:entry will have one lire:group. -->

  <xsl:template name="find.max.nesting">
    <xsl:param name="group-list" select="current()//lire:group"/>
    <xsl:param name="max-nesting" select="0"/>

    <xsl:choose>
      <!-- Done when group-list is empty -->
      <xsl:when test="not(count($group-list))">
	<xsl:value-of select="$max-nesting"/>
      </xsl:when>

      <xsl:otherwise>
	<xsl:variable name="my-nesting"
	  select="count($group-list[1]/ancestor-or-self::lire:group)"/>
	
	<xsl:choose>
	  <!-- Since the descendants:: axis traverse the tree
	  depth-first, we can assume that as soon as one node nesting is
	  lower then the precedent one we have finish processing the
	  first branch and can exit the recursion. --> 
	  <xsl:when test= "$my-nesting &lt;= $max-nesting">
	    <xsl:value-of select="$max-nesting"/>
	  </xsl:when>

	  <xsl:otherwise>
	    <!-- Recurse -->
	    <xsl:variable name="rest" select="$group-list[not(position()=1)]"/>

	    <xsl:call-template name="find.max.nesting">
	      <xsl:with-param name="group-list" select="$rest"/>
	      <xsl:with-param name="max-nesting">
		<xsl:value-of select="$my-nesting"/>
	      </xsl:with-param>
	    </xsl:call-template>
	  </xsl:otherwise>

	</xsl:choose>

      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template name="gen.colspec">
    <xsl:param name="col-count"/>
    <xsl:param name="col-idx" select="1"/>

    <xsl:choose>
      <!-- Last column -->
      <xsl:when test="$col-idx = $col-count">
	<colspec colname="ind{$col-idx}"/> 
      </xsl:when>

      <xsl:otherwise>
	<colspec colname="ind{$col-idx}" colwidth="30pt"/> 
	<xsl:call-template name="gen.colspec">
	  <xsl:with-param name="col-count" select="$col-count"/>
	  <xsl:with-param name="col-idx" select="$col-idx + 1"/>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>

  <xsl:template name="gen.spanspec">
    <xsl:param name="col-count"/>
    <xsl:param name="col-idx" select="1"/>

    <spanspec spanname="name{$col-idx}" namest="ind{$col-idx}" 
      nameend="ind{$col-count}"/> 

    <xsl:if test="$col-idx &lt; $col-count">
      <xsl:call-template name="gen.spanspec">
	<xsl:with-param name="col-count" select="$col-count"/>
	<xsl:with-param name="col-idx" select="$col-idx + 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="lire:table">
    <xsl:choose>
      <xsl:when test="lire:entry">
        <xsl:variable name="max-nesting">
          <xsl:call-template name="find.max.nesting"/>
        </xsl:variable>

        <xsl:if test="$debug">
          <xsl:comment>Max nesting: <xsl:value-of
	      select="$max-nesting"/></xsl:comment>
        </xsl:if>

        <informaltable frame="all">
          <tgroup cols="{$max-nesting + 2}" align="left" colsep="1"
	      rowsep="1">
	    <xsl:call-template name="gen.colspec">
	      <xsl:with-param name="col-count" select="$max-nesting + 1"/>
	    </xsl:call-template>
	    <colspec colname="value"/>
	    <xsl:call-template name="gen.spanspec">
	      <xsl:with-param name="col-count" select="$max-nesting + 1"/>
	    </xsl:call-template>
	    <tbody>
	      <xsl:apply-templates select="lire:entry"/>
	    </tbody>
          </tgroup>
        </informaltable>
      </xsl:when>
      <xsl:otherwise><para>No content in report.</para></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="lire:entry">
    <xsl:param name="col_idx" select="0"/>
    <row>
      <xsl:apply-templates select="lire:name">
	<xsl:with-param name="col_idx" select="$col_idx"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="lire:value"/>
    </row>
    <xsl:apply-templates select="lire:group">
      <xsl:with-param name="col_idx" select="$col_idx + 1"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="lire:group">
    <xsl:param name="col_idx" select="0"/>
    <xsl:apply-templates select="lire:entry">
      <xsl:with-param name="col_idx" select="$col_idx"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="lire:name">
    <xsl:param name="col_idx" select="0"/>

    <xsl:variable name="name" select="normalize-space(.)"/>
    <xsl:variable name="spanname" select="concat('name', $col_idx + 1)"/>

    <xsl:choose>

      <!-- Cropping needed -->
      <xsl:when test="string-length($name) &gt; $linewidth">
	<xsl:choose>

	  <!-- In group -->
	  <xsl:when test="ancestor::lire:group">
	    <entry spanname="{$spanname}"><emphasis><xsl:value-of
		  select="substring($name,1,$linewidth -
		  1)"/></emphasis></entry>
	  </xsl:when>

	  <!-- Top-level name -->
	  <xsl:otherwise>
	    <entry spanname="{$spanname}"><xsl:value-of
		select="substring($name,1,$linewidth -
		1)"/></entry>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:when>
      
      <!-- No need to crop the name -->
      <xsl:otherwise>
	<xsl:choose>

	  <!-- In group -->
	  <xsl:when test="ancestor::lire:group">
	    <entry spanname="{$spanname}"><emphasis><xsl:value-of
	    select="$name"/></emphasis></entry>
	  </xsl:when>

	  <!-- Top-level name -->
	  <xsl:otherwise>
	    <entry spanname="{$spanname}"><xsl:value-of select="$name"/></entry>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="lire:value">
    <entry colname="value"><xsl:value-of select="normalize-space(.)"/></entry>
  </xsl:template>
  
  <xsl:template match="lire:image">
    <mediaobject>
      <imageobject>
        <imagedata fileref="{lire:file}" format="{lire:file/@format}"/>
      </imageobject>
      <xsl:if test="lire:title">
	<caption>
	  <para><xsl:value-of select="lire:title"/></para>
	</caption>
      </xsl:if>
    </mediaobject>
  </xsl:template>

</xsl:stylesheet>

<!-- 
Keep this comment at the end of the file
Local variables:
mode: xml
sgml-indent-step: 2
End:
-->
