Summary: Listar modular mailing list manager
Name: listar
Distribution: Red Hat Contrib|Net
Vendor: NodeRunner Software
Version: 0.129a
Release: 1
Copyright: GPL
Group: Applications/Mail
Source: ftp://ftp.listar.org/pub/listar/%{name}-%{version}.tar.gz
URL: http://www.listar.org/
Prefix: /home/listar
Packager: Red Hat Contrib|Net <rhcn-bugs@redhat.com>
Buildroot: /var/tmp/listar-root

%changelog
* Tue Apr 4 2000 Jamie Blackman <sparks@noderunner.net>
- Updated the spec for the template directory.

* Fri Jun 2 1999 JT Traub <jtraub@dragoncat.net>
- Updated the spec for multiple changelog files.

* Mon Mar 8 1999 JT Traub <jtraub@dragoncat.net>
- Added the changelog section to the SPEC file.

%description
Listar is a modular mailing list manager; all its functionality is
encapsulated in individual 'lpm' (Listar Plugin Module) files.  This
allows new commands and functionality to be added on the fly.  Listar
has several useful features, including the ability to have 'flags' set on
user accounts (similar to L-soft Listserv), and a very secure remote
administration method over e-mail.

Errors to this package should be reported to bugs@listar.org or via the
web at http://bugs.listar.org/listar

%prep
%setup -q

%build
cd src
cp Makefile.dist Makefile
make install

%install
rm -Rf $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT/home/listar/{queue,modules,lists,scripts,templates}
install -s listar $RPM_BUILD_ROOT/home/listar
install -s modules/*.lpm $RPM_BUILD_ROOT/home/listar/modules
install scripts/* $RPM_BUILD_ROOT/home/listar/scripts
install listar.cfg.dist $RPM_BUILD_ROOT/home/listar/listar.cfg
install listar.aliases.dist $RPM_BUILD_ROOT/home/listar/listar.aliases
install banned $RPM_BUILD_ROOT/home/listar/banned
install spam-regexp.sample $RPM_BUILD_ROOT/home/listar/spam-regexp.sample
install listar.hlp $RPM_BUILD_ROOT/home/listar/listar.hlp
install templates/*.lsc $RPM_BUILD_ROOT/home/listar/templates

%pre
[ "`id -gn listar 2> /dev/null`" = "listar" ] || {
        cat <<EOF

This package requires an account for user "listar" with primary group
"listar".  We test [ "\`id -gn listar 2> /dev/null\`" = "listar" ].  Please
create the required account and try again.

On a Red Hat 5.x system you can create a suitable account like this:

        useradd -d /home/listar -s /bin/false listar

where /home/listar is the prefix you provided for install and defaults to
/home/listar.  If you wanted to install in /var/listar, for example, you
would make that the user's home directory, and add --prefix /var/listar
to the RPM command installing this package.

The listar user does NOT need any special permissions, it is merely to
ensure file ownership stays safe, and that Listar is suid to something
non-root when called by a mailserver.

Aborting.

EOF
        exit 1
}
exit 0

%post
cat << EOF
You will need to make some changes to your sendmail/other SMTP server
installation (such as adding alias files so that Listar aliases have
somewhere to live).  Very rudimentary documentation is in the installed
documentation directory in the file README.

If you have any problems, please feel free to subscribe to
the support list at listar-support@listar.org and we'll try to help you.

Simply send mail to listar-support-request@listar.org with a subject of
subscribe, a'la:

mail -s "subscribe" listar-support-request@listar.org < /dev/null

EOF
exit 0
%clean
rm -Rf $RPM_BUILD_ROOT

%files
%defattr(-,listar,listar)
%doc README README.* NOTE LICENSE PLATFORMS src/CHANGELOG src/CHANGELOG.*
%attr(4755,listar,listar) %{prefix}/listar
%attr(751,listar,listar)  %dir %{prefix}/lists
%attr(750,listar,listar)  %dir %{prefix}/queue
%attr(750,listar,listar)  %{prefix}/modules/*
%{prefix}/scripts/*
%config %{prefix}/listar.cfg
%config %{prefix}/listar.aliases
%config %{prefix}/banned
%{prefix}/spam-regexp.sample
%{prefix}/listar.hlp
%config %{prefix}/templates/*
