#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifndef WIN32
#include <unistd.h>
#endif

#include "listargate.h"

void lsg_listmenu()
{
   char buf[BIG_BUF];
   struct list_user user;
   int subbed;

   sprintf(buf,"List Menu: %s", LMAPI->get_string("lsg-list"));

   LMAPI->set_var("list", LMAPI->get_string("lsg-list"), VAR_GLOBAL);
   LMAPI->list_read_conf();

   lsg_header(buf);

   subbed = LMAPI->user_find_list(LMAPI->get_string("lsg-list"),
        LMAPI->get_string("user"), &user);

   printf("<font size=+2><b>List Menu</b> (for list \"%s\")</font><P>\n",
        LMAPI->get_string("lsg-list"));

   printf("<table border=0>\n");
   printf("<tr><td valign=top>\n");
   printf("<b>Current user:</b> %s<BR>\n", LMAPI->get_string("user"));

   if (subbed) {
      printf("<b>Subscribed as:</b> %s<BR>\n", user.address);
   } else {
      printf("<b>Not Subscribed</b><BR>\n");
   }

   printf("</td><td width=15%%>&nbsp;</td><td valign=top rowspan=3>\n");

   printf("<b>Available actions/submenus</b>:<BR>\n");

   if (subbed) {
      lsg_baseform("unsubscribe");
      printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
         LMAPI->get_string("lsg-list"));
      printf("<input type=submit value=\"Unsubscribe from %s\">\n",
         LMAPI->get_string("lsg-list"));
      printf("</form>\n");

      lsg_baseform("flagedit");
      printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
         LMAPI->get_string("lsg-list"));
      printf("<input type=submit value=\"Edit subscription\">\n");
      printf("</form><BR>\n");

      if (!strcasecmp(LMAPI->get_string("who-status"),"public")) {
         lsg_baseform("listusers");
         printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
            LMAPI->get_string("lsg-list"));
         printf("<input type=submit value=\"View list subscribers\">\n");
         printf("</form>");
      }
   } else {
      lsg_baseform("subscribe");
      printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
         LMAPI->get_string("lsg-list"));
      printf("<input type=submit value=\"Subscribe to %s\">\n",
         LMAPI->get_string("lsg-list"));
      printf("</form>\n");

      if (!strcasecmp(LMAPI->get_string("who-status"),"public")) {
         lsg_baseform("listusers");
         printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
            LMAPI->get_string("lsg-list"));
         printf("<input type=submit value=\"View list subscribers\">\n");
         printf("</form>\n");
      }

      printf("<BR>\n");
   }

   if (LMAPI->get_var("welcome-file")) {
      lsg_baseform("listintro");
      printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
          LMAPI->get_string("lsg-list"));
      printf("<input type=submit value=\"View list intro file\">\n");
      printf("</form>\n");
   }

   if (LMAPI->get_var("faq-file")) {
      lsg_baseform("listfaq");
      printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
          LMAPI->get_string("lsg-list"));
      printf("<input type=submit value=\"View list FAQ\">\n");
      printf("</form>\n");
   }

   if (LMAPI->get_var("info-file")) {
      lsg_baseform("listinfo");
      printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
          LMAPI->get_string("lsg-list"));
      printf("<input type=submit value=\"View list info file\">\n");
      printf("</form>\n");
   }

   if (subbed) {
      if (LMAPI->user_hasflag(&user,"ADMIN")) {
         printf("<HR><b>Admin actions/submenus:</b><BR>\n");

/*
         lsg_baseform("getconf");
         printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
             LMAPI->get_string("lsg-list"));
         printf("<input type=submit value=\"Get list config\">\n");
         printf("</form>\n");
 */
         printf("None yet.");
      }
   }

   printf("</td></tr>\n");
   printf("<tr><td>\n");

   if (LMAPI->get_var("description")) {
      printf("<b>List description:</b><BR>\n%s\n",
         LMAPI->get_string("description"));
   } else printf("&nbsp;");

   printf("</td>\n<td></td></tr>\n");

   printf("<tr><td valign=bottom>\n");
   lsg_baseform("mainmenu");
   printf("<input type=hidden name=\"user\" value=\"%s\">\n", 
       LMAPI->get_string("user"));
   printf("<input type=submit value=\"Return to Main Menu\">\n");
   printf("</form>\n");
   printf("</td><td></td>\n");
   printf("</table>");

   lsg_footer();
}

void lsg_unsubscribe()
{
   char buf[BIG_BUF];
   struct list_user user;

   lsg_header("Unsubscribe");

   LMAPI->set_var("list",LMAPI->get_string("lsg-list"), VAR_GLOBAL);
   LMAPI->list_read_conf();

   if (!LMAPI->user_find_list(LMAPI->get_string("list"), LMAPI->get_string("user"),
       &user)) {
      printf("<b>Unable to Unsubscribe:</b><BR>\n");
      printf("You are not subscribed to this list.\n");
   } else {
      LMAPI->set_var("fromaddress",LMAPI->get_string("user"),VAR_GLOBAL);

      LMAPI->listdir_file(buf, LMAPI->get_string("lsg-list"), "users");

      LMAPI->set_var("subscribe-me", user.address,VAR_GLOBAL);
      LMAPI->set_var("realsender",LMAPI->get_string("listserver-address"),VAR_GLOBAL);
      LMAPI->set_var("fromaddress",LMAPI->get_string("listserver-address"),VAR_GLOBAL);

      LMAPI->result_printf("Commands generated from Listargate\n");

      sprintf(buf,"unsubscribe %s %s",LMAPI->get_string("lsg-list"),user.address);

      LMAPI->set_var("cur-parse-line",buf, VAR_GLOBAL);

      if (LMAPI->do_hooks("PREUNSUB") == HOOK_RESULT_FAIL) {
         printf("<b>Unsubscription confirmation ticket sent.</b><BR>\n");
         printf("An unsubscription confirmation ticket has been sent to the\n");
         printf("address in question.\n");
      }

      LMAPI->set_var("realsender",LMAPI->get_string("user"),VAR_GLOBAL);
   }

   lsg_baseform("listmenu");
   printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
      LMAPI->get_string("list"));
   printf("<input type=submit value=\"Return to List Menu\">\n");
   printf("</form>\n");

   lsg_footer();
}

void lsg_subscribe()
{
   char buf[BIG_BUF];
   struct list_user user;

   lsg_header("Subscribe");

   LMAPI->set_var("list",LMAPI->get_string("lsg-list"), VAR_GLOBAL);
   LMAPI->list_read_conf();

   if (LMAPI->user_find_list(LMAPI->get_string("list"), LMAPI->get_string("user"),
       &user)) {
      printf("<b>Unable to Subscribe:</b><BR>\n");
      printf("You are already subscribed to this list.<BR><BR>\n");

      if(LMAPI->user_hasflag(&user,"VACATION")) {
         printf("You are set 'VACATION', and thus are not receiving any mail.<P>\n");
      } else
      if (LMAPI->user_hasflag(&user,"DIAGNOSTIC")) {
         printf("You are set 'DIAGNOSTIC' and receive only reports.<P>\n");
      }
      if (LMAPI->user_hasflag(&user,"DIGEST")) {
         printf("You are set 'DIGEST' and will receive posts only when a digest is ready to send.<P>\n");
      }
   } else {
      LMAPI->set_var("fromaddress",LMAPI->get_string("user"),VAR_GLOBAL);

      LMAPI->listdir_file(buf, LMAPI->get_string("lsg-list"), "users");

      LMAPI->set_var("subscribe-me", LMAPI->get_string("user"),VAR_GLOBAL);
      LMAPI->set_var("realsender",LMAPI->get_string("listserver-address"),VAR_GLOBAL);
      LMAPI->set_var("fromaddress",LMAPI->get_string("listserver-address"),VAR_GLOBAL);

      LMAPI->result_printf("Commands generated from Listargate\n");

      sprintf(buf,"subscribe %s %s",LMAPI->get_string("lsg-list"),
          LMAPI->get_string("user"));

      LMAPI->set_var("cur-parse-line",buf, VAR_GLOBAL);

      if (LMAPI->do_hooks("PRESUB") == HOOK_RESULT_FAIL) {
         printf("<b>Subscription confirmation ticket sent.</b><BR>\n");
         printf("A subscription confirmation ticket has been sent to the\n");
         printf("address in question.\n");
      }

      LMAPI->set_var("realsender",LMAPI->get_string("user"),VAR_GLOBAL);
   }
  
   lsg_baseform("listmenu");
   printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
      LMAPI->get_string("list"));
   printf("<input type=submit value=\"Return to List Menu\">\n");
   printf("</form>\n");

   lsg_footer();
}

void lsg_showintro()
{
   FILE *welcomefile;
   char buf[BIG_BUF];

   sprintf(buf,"Intro for list '%s'", LMAPI->get_string("lsg-list"));
   lsg_header(buf);

   LMAPI->listdir_file(buf, LMAPI->get_string("lsg-list"),
                       LMAPI->get_string("welcome-file"));

   if (!LMAPI->exists_file(buf)) {
      printf("<b>No welcome text for this list.</b><BR>\n");
   } else {
      printf("This is the welcome text that is sent when a user subscribes.\n");
      printf("<HR>\n<pre>");

      welcomefile = LMAPI->open_file(buf,"r");

      if (welcomefile) {
         while(LMAPI->read_file(buf, BIG_BUF, welcomefile)) {
            printf(buf);
         }
      }
      LMAPI->close_file(welcomefile);

      printf("</pre><HR>\n");
   }

   lsg_baseform("listmenu");
   printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
      LMAPI->get_string("lsg-list"));
   printf("<input type=submit value=\"Return to List Menu\">\n");
   printf("</form>\n");

   lsg_footer();
}

void lsg_showfaq()
{
   FILE *welcomefile;
   char buf[BIG_BUF];

   sprintf(buf,"FAQ for list '%s'", LMAPI->get_string("lsg-list"));
   lsg_header(buf);

   LMAPI->listdir_file(buf, LMAPI->get_string("lsg-list"),
                       LMAPI->get_string("faq-file"));

   if (!LMAPI->exists_file(buf)) {
      printf("<b>No FAQ for this list.</b><BR>\n");
   } else {
      printf("This is the file that is sent when a user requests the FAQ.\n");
      printf("<HR>\n<pre>");

      welcomefile = LMAPI->open_file(buf,"r");

      if (welcomefile) {
         while(LMAPI->read_file(buf, BIG_BUF, welcomefile)) {
            printf(buf);
         }
      }
      LMAPI->close_file(welcomefile);

      printf("</pre><HR>\n");
   }

   lsg_baseform("listmenu");
   printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
      LMAPI->get_string("lsg-list"));
   printf("<input type=submit value=\"Return to List Menu\">\n");
   printf("</form>\n");

   lsg_footer();
}

void lsg_showinfo()
{
   FILE *welcomefile;
   char buf[BIG_BUF];

   sprintf(buf,"Info for list '%s'", LMAPI->get_string("lsg-list"));
   lsg_header(buf);

   LMAPI->listdir_file(buf, LMAPI->get_string("lsg-list"),
                       LMAPI->get_string("info-file"));

   if (!LMAPI->exists_file(buf)) {
      printf("<b>No info file for this list.</b><BR>\n");
   } else {
      printf("This is the file that is sent when a user requests list info.\n");
      printf("<HR>\n<pre>");

      welcomefile = LMAPI->open_file(buf,"r");

      if (welcomefile) {
         while(LMAPI->read_file(buf, BIG_BUF, welcomefile)) {
            printf(buf);
         }
      }
      LMAPI->close_file(welcomefile);

      printf("</pre><HR>\n");
   }

   lsg_baseform("listmenu");
   printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
      LMAPI->get_string("lsg-list"));
   printf("<input type=submit value=\"Return to List Menu\">\n");
   printf("</form>\n");

   lsg_footer();
}

void lsg_showusers()
{
   char buf[BIG_BUF];
   FILE *userfile;
   struct list_user user;
   int failure;

   sprintf(buf,"Subscribers on list '%s'", LMAPI->get_string("lsg-list"));
   lsg_header(buf);

   LMAPI->set_var("list", LMAPI->get_string("lsg-list"), VAR_GLOBAL);
   LMAPI->list_read_conf();

   failure = 0;

   if (!strcasecmp(LMAPI->get_string("who-status"),"admin")) {
      printf("<b>User list not viewable</b><BR>\n");
      printf("This list is not viewable over Listargate.\n");

      failure = 1;

   } else {
      if (!strcasecmp(LMAPI->get_string("who-status"),"private") ||
          !strcasecmp(LMAPI->get_string("who-status"),"admin")) {
            printf("<b>User list not viewable</b><BR>\n");
            printf("This list is not viewable over Listargate.\n");

            failure = 1;
      }
   }

   if (!failure) {
      LMAPI->listdir_file(buf, LMAPI->get_string("lsg-list"), "users");
      if ((userfile = LMAPI->open_file(buf,"r")) == NULL) {
         printf("<b>Unable to display users</b><BR>\n");
         printf("There was a disk error.\n");
      } else {
         int hidden, diagnostic, total;

         printf("<font size=+2><b>Users on list '%s':</b></font><BR>\n<HR>\n",
             LMAPI->get_string("lsg-list"));
    
         printf("<table border=1 width=50%%>\n");
         printf("<tr>\n");
         printf("<td bgcolor=#dedede><b>Address</b></td>");
         printf("<td bgcolor=#dedede><b>Admin</b></td>");
         printf("<td bgcolor=#dedede><b>Vacation</b></td>");
         printf("<td bgcolor=#dedede><b>Digest</b></td>");
         printf("</tr>\n");

         hidden = 0; total = 0; diagnostic = 0;

         while(LMAPI->user_read(userfile,&user)) {
            total++;
            if(!LMAPI->user_hasflag(&user,"HIDDEN") && !LMAPI->user_hasflag(&user,"DIAGNOSTIC")) {
               char buffer[256];

               printf("<tr>\n");
               printf("\t<td>");
               if (LMAPI->userstat_get_stat(LMAPI->get_string("lsg-list"),user.address,"realname",&buffer[0],255)) {
                  printf("%s<BR>", buffer);
               }
               printf("&lt;%s&gt;</td>\n", user.address);
               printf("\t<td align=center>%s</td>\n",
                  LMAPI->user_hasflag(&user, "ADMIN") ? "<b>X</b>" : "&nbsp;");
               printf("\t<td align=center>%s</td>\n",
                  LMAPI->user_hasflag(&user, "VACATION") ? "<b>X</b>" : "&nbsp;");
               printf("\t<td align=center>%s</td>\n",
                  LMAPI->user_hasflag(&user, "DIGEST") ? "<b>X</b>" : "&nbsp;");
               printf("</tr>\n");
            } else {
               if (LMAPI->user_hasflag(&user,"HIDDEN")) hidden++; else
               if (LMAPI->user_hasflag(&user,"DIAGNOSTIC")) diagnostic++;
            }
         }
         LMAPI->close_file(userfile);
         printf("</table><BR>\n");
         printf("There are <b>%d</b> hidden users and <b>%d</b> \n",
            hidden, diagnostic);
         printf("diagnostic users not shown.<BR>\n");
         printf("There are a total of <b>%d</b> users.<BR>\n", total);
      }
   }

   lsg_baseform("listmenu");
   printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
      LMAPI->get_string("lsg-list"));
   printf("<input type=submit value=\"Return to List Menu\">\n");
   printf("</form>\n");

   lsg_footer();
}

void lsg_flagedit()
{
   char buf[BIG_BUF];
   struct list_user user;
   struct listserver_flag *temp;
   int flags;

   sprintf(buf, "Subscription options for %s on %s",
      LMAPI->get_string("user"), LMAPI->get_string("lsg-list"));

   lsg_header(buf);

   if (!LMAPI->user_find_list(LMAPI->get_string("lsg-list"),LMAPI->get_string("user"), &user)) {
      printf("User %s is not subscribed to list %s.", LMAPI->get_string("user"),
              LMAPI->get_string("lsg-list"));
   } else {
      printf("<font size=+2><b>Flags for %s on list %s</b></font><P>\n",
           user.address, LMAPI->get_string("lsg-list"));

      printf("Only flags which are settable by non-admins are shown here.<BR>\n");

      printf("<HR>");

      temp = LMAPI->get_flags();

      printf("<center><form><table width=80%% border=0>\n");
      printf("<tr>\n");

      flags = 0;

      while(temp)
      {
         if (!strcasecmp(temp->name,"superadmin") || temp->admin) {
            temp = temp->next;
            continue;
         }
         flags++;
         if (flags > 2) {
            flags = 1;
            printf("</tr>\n<tr>\n");
         }
         printf("\t<td valign=top>\n");
         if (LMAPI->user_hasflag(&user,temp->name)) {
            printf("\t\t<input type=\"checkbox\" checked=\"true\"> %s",temp->name);
         } else {
            printf("\t\t<input type=\"checkbox\"> %s",temp->name);
         }
         printf("\n\t\t<ul><font size=-1>%s</font></ul>&nbsp;\n", temp->desc);
         printf("\t</td>\n");
         temp = temp->next;
      }

      printf("</table></form></center>\n");
   }

   lsg_baseform("listmenu");
   printf("<input type=hidden name=\"lsg-list\" value=\"%s\">\n",
      LMAPI->get_string("lsg-list"));
   printf("<input type=submit value=\"Return to List Menu\">\n");
   printf("</form>\n");

   lsg_footer();
}
