/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandUntil: public LWParityCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 1, NULL);
	g_return_val_if_fail (context->instrPtr->prev != NULL, NULL);
	
	if (0 == args[0]->toInt())
		context->instrPtr = context->instrPtr->prev;
	
	return NULL;
}

gchar *getName ()
{
	return "until";
}	

gchar *getHint ()
{
	return _("Until");
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

gboolean isOpen ()
{
	return FALSE;	
}

void matchWith (LWCommand *cmd)
{
	if (g_strcasecmp (cmd->getName(), "repeat"))
			throw new LWMessage (LW_ERROR_UntilButWhereIsRepeat);
	
	match();
}

};

LWSymbol *new_LWCommandUntil()
{
	return new LWCommandUntil();
}
