; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mcpu=yonah -mtriple=i386-apple-darwin | FileCheck %s


define <4 x i32> @test1(<4 x i32> %A, <4 x i32> %B) nounwind {
; CHECK-LABEL: test1:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    pcmpgtd %xmm1, %xmm0
; CHECK-NEXT:    retl

	%C = icmp sgt <4 x i32> %A, %B
        %D = sext <4 x i1> %C to <4 x i32>
	ret <4 x i32> %D
}

define <4 x i32> @test2(<4 x i32> %A, <4 x i32> %B) nounwind {
; CHECK-LABEL: test2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    pcmpgtd %xmm0, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp sge <4 x i32> %A, %B
        %D = sext <4 x i1> %C to <4 x i32>
	ret <4 x i32> %D
}

define <4 x i32> @test3(<4 x i32> %A, <4 x i32> %B) nounwind {
; CHECK-LABEL: test3:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    pcmpgtd %xmm0, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp slt <4 x i32> %A, %B
        %D = sext <4 x i1> %C to <4 x i32>
	ret <4 x i32> %D
}

define <4 x i32> @test4(<4 x i32> %A, <4 x i32> %B) nounwind {
; CHECK-LABEL: test4:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    pcmpgtd %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp ugt <4 x i32> %A, %B
        %D = sext <4 x i1> %C to <4 x i32>
	ret <4 x i32> %D
}

define <2 x i64> @test5(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test5:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; CHECK-NEXT:    pand %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp eq <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test6(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test6:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; CHECK-NEXT:    pand %xmm1, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm1
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp ne <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test7(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test7:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,0,2147483648,0]
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm1, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp sgt <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test8(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test8:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,0,2147483648,0]
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm0, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp slt <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test9(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test9:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,0,2147483648,0]
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm0, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp sge <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test10(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test10:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,0,2147483648,0]
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm1, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp sle <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test11(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test11:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm1, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp ugt <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test12(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test12:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm0, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp ult <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test13(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test13:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    movdqa %xmm1, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm0, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm1
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp uge <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}

define <2 x i64> @test14(<2 x i64> %A, <2 x i64> %B) nounwind {
; CHECK-LABEL: test14:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; CHECK-NEXT:    pxor %xmm2, %xmm1
; CHECK-NEXT:    pxor %xmm2, %xmm0
; CHECK-NEXT:    movdqa %xmm0, %xmm2
; CHECK-NEXT:    pcmpgtd %xmm1, %xmm2
; CHECK-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; CHECK-NEXT:    pand %xmm3, %xmm0
; CHECK-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; CHECK-NEXT:    por %xmm0, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retl
	%C = icmp ule <2 x i64> %A, %B
	%D = sext <2 x i1> %C to <2 x i64>
	ret <2 x i64> %D
}
