//=====-- PIC16Subtarget.h - Define Subtarget for the PIC16 ---*- C++ -*--====//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source 
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file declares the PIC16 specific subclass of TargetSubtarget.
//
//===----------------------------------------------------------------------===//

#ifndef PIC16SUBTARGET_H
#define PIC16SUBTARGET_H

#include "llvm/Target/TargetSubtarget.h"

#include <string>

namespace llvm {

class PIC16Subtarget : public TargetSubtarget {

  // IsCooper - Target ISA is Cooper.
  bool IsCooper;

public:
  /// This constructor initializes the data members to match that
  /// of the specified triple.
  ///
  PIC16Subtarget(const std::string &TT, const std::string &FS, bool Cooper);
  
  /// isCooper - Returns true if the target ISA is Cooper.
  bool isCooper() const { return IsCooper; }

  /// ParseSubtargetFeatures - Parses features string setting specified 
  /// subtarget options.  Definition of function is auto generated by tblgen.
  std::string ParseSubtargetFeatures(const std::string &FS,
                                     const std::string &CPU);
};
} // End llvm namespace

#endif  // PIC16SUBTARGET_H
