/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

void lib_update_file(file_t * file);
void lib_share_file(file_t * file, int important);
void lib_unshare_file(file_t * file);
void lib_remove_file(file_t * file);
void lib_delete_file(file_t * file);
void lib_insert_file(file_t * file);
void lib_apply_file(file_t * file);

int lib_share_timeout(gpointer data);

void lib_refresh();
int lib_load(char *fname, int add);
void lib_save();
void lib_apply();
void lib_search(search_t * search);

void lib_update_stats();
void lib_enter(char* info);
int lib_is_busy();
void lib_leave();
void lib_show();

gint lib_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2);

file_t *file_create_from_local(char *name);

suffix_t *check_suffix(char *name, int mime);

void lib_tree_update_file(file_t * file, GtkCTreeNode* node);
void lib_tree_update_file_fb(file_t * file, GtkCTreeNode* node);
void lib_apply_node(GtkCTreeNode * node);
void lib_set_flag(int val, GtkCTreeNode * node);
void lib_del_flag(int val, GtkCTreeNode * node);
void lib_replace_flag(int val1, int val2, GtkCTreeNode * node);
void lib_xor_flag(int val1, int val2, GtkCTreeNode * node);

GtkWidget *create_files_popup();
GtkWidget *create_lib_popup2(void);

void lib_compare_with_browse(user_t * userinfo);
file_t *lib_search_transfer(transfer_t * transfer);
GList* lib_search_file_type(file_t* file);

void lib_start_sharing();
