/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

extern const int StatusInfo[S_NUMBER];

char *status_names(int status);
char *valid_download_folder(int mime);

// generic transfer stuff
transfer_t *transfer_new();
void transfer_destroy(transfer_t * transfer);
void transfer_hide(socket_t * socket);
int transfer_in_progress(transfer_t * transfer);
int transfer_status_dist(int s1, int s2);
void transfer_status_set(socket_t * socket, int status);
void transfer_connect_and_start(socket_t * socket);
GdkPixmap *transfer_draw_progress(GtkCList * clist, GdkPixmap * pixmap,
				  double percent, int width, int active);
void transfer_update(socket_t * socket, int full);
void transfer_start_queued();
void transfer_end(socket_t * socket, int mode);
gint transfer_send_info(gpointer data, gint source,
			GdkInputCondition condition);
gint transfer_get_info(gpointer data, gint source,
		       GdkInputCondition condition);
void transfer_detect_user_info(transfer_t * transfer, char* user);
int transfer_to_destroy(socket_t * socket, int mode);
int transfer_to_retry(int mode);
int transfer_to_delete(transfer_t * transfer, int mode);
int transfer_grab_resume(socket_t * socket, resume_t * resume);
void transfer_ungrab_resume(socket_t * socket);
resume_t *transfer_create_resume(transfer_t * transfer);
int transfer_search_queued(resume_t * resume);
void transfer_cancel_running();
void transfer_remove(socket_t * socket);

// download stuff
void download_update(socket_t * socket);
socket_t *download_create(file_t * file, int withdir, resume_t* resume);
socket_t *download_search_mapable(char *user, char *winname);
void download_file(file_t * file, int withdir);
void download_file_without_check(file_t* file, int withdir);
int download_allowed(socket_t * socket);
void download_show(socket_t * socket);
void download_hide(socket_t * socket);
void download_start(socket_t * socket, int force);
FILE *download_open_file(transfer_t * transfer);
void download_end(socket_t * socket, int mode);
gint download_get_info(gpointer data, gint source,
		       GdkInputCondition condition);
gint download_get_input(gpointer data, gint source,
			GdkInputCondition condition);
int download_timeout(gpointer data);
void downloads_disable();
void downloads_enable();

// upload stuff
int upload_update(socket_t * socket);
socket_t *upload_search_mapable(char *user, char *winname);
int upload_allowed(transfer_t * transfer, int eject);
void upload_show(socket_t * socket);
void upload_hide(socket_t * socket);
void upload_start(socket_t * socket, int force);
FILE *upload_open_file(transfer_t * transfer);
void upload_end(socket_t * socket, int mode);
gint upload_get_info(gpointer data, gint source,
		     GdkInputCondition condition);
gint upload_push_output(gpointer data, gint source,
			GdkInputCondition condition);
void uploads_disable();
void uploads_enable();
int remove_dead_transfers(gpointer data);
void remove_dead_uploads();
void remove_dead_downloads();

// transfer popups
GtkWidget *create_dl_remove_popup(int val);
GtkWidget *create_retry_popup(int val);
GtkWidget *create_ul_remove_popup(int val);
GtkWidget *create_advanced_popup(int val);
GtkWidget *create_upload_popup(transfer_t * transfer);
GtkWidget *create_download_popup();

// dcc stuff
void dcc_send_file(char *nick, char *file);
void dcc_select_file(char *nick);
int dcc_check_message(char *from, char *message);

// global stuff
int global_timer(gpointer data);
gint await_conn_ack(gpointer data, gint source,
		    GdkInputCondition condition);

void create_bandwidth_win(char* user, int download);
GtkWidget* create_bandwidth_popup(int mode);
void create_bandman_win (int download);

void upload_update_speed(user_info_t* userinfo);
