# Copyright (C) 2008-2010 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

from kiwi.ui.delegates import SlaveDelegate

class ConfigView(SlaveDelegate):
    gladefile = "remote_frontend_config_view"
    
    def __init__(self, mode):
        self.mode = mode
        
        SlaveDelegate.__init__(self)
        
        for widget in [self.address, self.port, self.password]:
            widget.mandatory = True
        
        self.add_proxy(self.mode.config,["address", "port", "password"])