/*
 * dmnt.c -- AIX mount functions for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.3 99/11/10 15:00:18 abe Exp $";
#endif


#include "lslk.h"


/*
 * readmnt() - read mount table
 */

int
readmnt()
{
	char *dir, *fs, *h, *m, *s, *ty;
	int err = 0;
	MALLOC_S len;
	int na = 0;
	int nm;
	struct stat sb;
	unsigned sz;
	struct vmount *v, *vt;
/*
 * Read the table of vmount structures.
 */
	for (sz = sizeof(struct vmount);;) {
	    if ((vt = (struct vmount *)malloc(sz)) == NULL) {
		(void) fprintf(stderr, "%s: no space for vmount table\n", Pn);
		return(0);
	    }
	    nm = mntctl(MCTL_QUERY, sz, vt);
	    if (nm > 0) {
		if (vt->vmt_revision != VMT_REVISION) {
		    (void) fprintf(stderr,
			"%s: stale file system, rev %d != %d\n",
			Pn, vt->vmt_revision, VMT_REVISION);
		    return(1);
		}
		break;
	    }
	    if (nm == 0) {
		sz = (unsigned)vt->vmt_revision;
		(void) free((MALLOC_P *)vt);
	    } else {
		(void) fprintf(stderr, "%s: mntctl error: %s\n",
		    Pn, strerror(errno));
		return(1);
	    }
	}
/*
 * Scan the vmount structures and build Mtab.
 */
	for (v = vt; nm--; v = (struct vmount *)((char *)v + v->vmt_length)) {
	    dir = (char *)vmt2dataptr(v, VMT_STUB);
	    fs = (char *)vmt2dataptr(v, VMT_OBJECT);
	    h = (char *)vmt2dataptr(v, VMT_HOST);
	/*
	 * Skip all but JFS devices -- i.e., the ones that have inodes.
	 */
	    if ((v->vmt_gfstype & MNT_JFS) == 0)
		continue;
	/*
	 * Stat() the file system directory.
	 */
	    if (statsafely(dir, &sb)) {
		err = 2;
		if (Owarn) {

		/*
		 * Issue stat() failure warning.
		 */
		    (void) fprintf(stderr,
			    "%s: WARNING: can't stat() file system %s\n",
			    Pn, dir);
		    (void) fprintf(stderr,
			    "      Output information may be incomplete.\n");
		}
	    /*
	     * Assemble alternate device number and mode flags.
	     */
		    (void) bzero((char *)&sb, sizeof(sb));
		    sb.st_dev = (dev_t)v->vmt_fsid.val[0];
		    sb.st_mode = S_IFDIR | 0777;
		    if (Owarn)
			(void) fprintf(stderr,
			    "      assuming \"dev=%#lx\" from mount table\n",
			    sb.st_dev);
	    }
	/*
	 * See if there's room in the local mount table for another entry.
	 */
	    if (NMnt >= na) {

	    /*
	     * Increase the space allocated to the local mount table and
	     * reserve space for the increase.
	     */
		na += 10;
		len = (MALLOC_S)(na * sizeof(struct mounts));
		if (Mnt)
		    Mnt = (struct mounts *)realloc((MALLOC_P *)Mnt, len);
		else
		    Mnt = (struct mounts *)malloc(len);
		if (!Mnt) {
		    (void) fprintf(stderr,
			"%s: no room for %d mount structures at %s: %s\n",
			Pn, na, s, dir);
		    return(1);
		}
	    }
	/*
	 * Allocate space for what's been mounted (fs) and where
	 * it's been mounted (dir).
	 */
	    if ((m = (char *)malloc(strlen(dir) + 1)) == (char *)NULL) {
		(void) fprintf(stderr, "%s: no room for mount point: %s\n",
		    Pn, dir);
		return(1);
	    }
	    (void) strcpy(m, dir);
	    if ((s = (char *)malloc(strlen(fs) + 1)) == (char *)NULL) {
		(void) fprintf(stderr, "%s: no room for special: %s\n",
			Pn, fs);
		return(1);
	    }
	    (void) strcpy(s, fs);
	/*
	 * Create the new local mount information entry.  Avoid a stat()
	 * call by getting the device number from the file system ID.
	 */
	    Mnt[NMnt].dev = (dev_t)v->vmt_fsid.val[0];
	    Mnt[NMnt].sp = s;
	    Mnt[NMnt].priv = (caddr_t)NULL;
	    Mnt[NMnt++].mntp = m;
        }
	return(0);
}
