#!/bin/bash

# check for pending changes
PENDING=$(bzr status -S)

if [ "x$PENDING" != "x" ]; then
    echo There are pending changes - you should commit these.
    echo $PENDING
    exit 1
fi

LAST_TAG=$(bzr tags | tail -n 1 | cut -d' ' -f1 | cut -d'-' -f2)
NEW_VER=$(($LAST_TAG + 1))

echo Last release was $LAST_TAG - the new release will be $NEW_VER

echo Changing release number in luxio.c
sed -e"s/^\#define LUXIO_RELEASE $LAST_TAG/#define LUXIO_RELEASE $NEW_VER/" -i luxio.c

echo commiting change and tagging
bzr commit -m "Update release number to $NEW_VER"
bzr tag luxio-$NEW_VER

echo exporting directory
bzr export --format dir ../luxio-$NEW_VER

pushd ../luxio-$NEW_VER

echo Generating documentation
ldoc .

cd ..

echo tar...
tar cvfj luxio-$NEW_VER.tar.bz2 luxio-$NEW_VER
rm -rf luxio-$NEW_VER

popd