/*
 * guess.c
 *
 * All rights reserved. Copyright (C) 1996-1999 by NARITA Tomio.
 * $Id: guess.c,v 1.4 1999/06/06 14:11:05 nrt Exp $
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>

#include <import.h>
#include <decode.h>
#include <big5.h>
#include <utf.h>
#ifndef MSDOS /* IF NOT DEFINED */
#include <unimap.h>
#include <unirev.h>
#endif /* MSDOS */
#include <begin.h>
#include <guess.h>

public byte GuessCodingSystem( byte *str, int length, byte defaultEuc )
{
  int i;
  byte ch;
  int big5Penalty = 0;
  int sjisPenalty = 0;
  int eucjapanPenalty = 0;
  int eucPenalty = 0;
#ifndef MSDOS /* IF NOT DEFINED */
  int utf8Penalty = 0;
#endif /* MSDOS */

  /*
   * Locale specific implementation is required.
   */
  for( i = 0 ; i < length ; i++ ){
    /*
     * check for simple euc
     */
    ch = str[ i ];
    if( 0x80 & ch ){
      if( SS2 == ch || SS3 == ch ){
	eucPenalty++;
	continue;
      }
      if( !IsEucByte( ch ) )
	eucPenalty++;
      if( ++i >= length )
	break;
      ch = str[ i ];
      if( !IsEucByte( ch ) )
	eucPenalty++;
    }
  }

  for( i = 0 ; i < length ; i++ ){
    /*
     * check for euc-japan or euc-taiwan
     */
    ch = str[ i ];
    if( 0x80 & ch ){
      if( SS2 == ch ){
	if( ++i >= length )
	  break;
	ch = str[ i ];
	if( !IsKatakanaByte( ch ) )
	  eucjapanPenalty++;
	continue;
      }
      if( SS3 == ch ){
	if( ++i >= length )
	  break;
	ch = str[ i ];
      }
      if( !IsEucByte( ch ) )
	eucjapanPenalty++;
      if( ++i >= length )
	break;
      ch = str[ i ];
      if( !IsEucByte( ch ) )
	eucjapanPenalty++;
    }
  }

  for( i = 0 ; i < length ; i++ ){
    /*
     * check for big5
     */
    ch = str[ i ];
    if( 0x80 & ch ){
      if( !IsBig5Byte1( ch ) )
	big5Penalty++;
      ch = str[ ++i ];
      if( i >= length )
	break;
      if( !IsBig5Byte2( ch ) )
	big5Penalty++;
    }
  }

  for( i = 0 ; i < length ; i++ ){
    /*
     * check for shift-jis
     */
    ch = str[ i ];
    if( 0x80 & ch ){
      if( IsKatakanaByte( ch ) )
	continue;
      if( !IsShiftJisByte1( ch ) )
	sjisPenalty++;
      ch = str[ ++i ];
      if( i >= length )
	break;
      if( !IsShiftJisByte2( ch ) )
	sjisPenalty++;
    }
  }
#ifndef MSDOS /* IF NOT DEFINED */
  { int idx;
    decoding_penalty = 0;
    idx = length;
    IstrFree( Decode( IstrAlloc( ZONE_FREE, idx + 1 ),
		     UTF_8, str, &idx ) );
    utf8Penalty = decoding_penalty;
  }
#endif /* MSDOS */

  if( 0 == eucPenalty )
    return defaultEuc;
  else if( 0 == eucjapanPenalty )
    return EUC_JAPAN;
  else if( 0 == big5Penalty )
    return BIG_FIVE;
  else if( 0 == sjisPenalty )
    return SHIFT_JIS;
#ifndef MSDOS /* IF NOT DEFINED */
  else if( 0 == utf8Penalty )
    return UTF_8;
#endif /* MSDOS */

  return ISO_8859_1;
}

public byte GuessHz( byte *str, int length )
{
  boolean_t gb = FALSE;
  int i, hzPenalty = 0;
  byte ch;

  for( i = 0 ; i < length ; i++ ){
    /*
     * check for HZ
     */
    ch = str[ i ];
    if( '~' == ch ){
      if( ++i >= length )
	break;
      ch = str[ i ];
      if( FALSE == gb ){
	if( '{' == ch ){
	  gb = TRUE;
	} else if( '~' == ch || '}' == ch ){
	  /* do nothing */
	} else
	  hzPenalty++;
      } else {
	if( '}' == ch )
	  gb = FALSE;
      }
    }
  }

  return 0 == hzPenalty;
}


public void AdjustPatternCharset( byte inputCodingSystem,
				 byte keyboardCodingSystem,
				 byte defaultCodingSystem,
				 i_str_t *istr )
{
  if( FALSE == adjust_charset )
    return;

#ifndef MSDOS /* IF NOT DEFINED */
  if( IsUtfEncoding( inputCodingSystem ) || IsUtfEncoding( keyboardCodingSystem ) ){
    if( IsUtfEncoding( inputCodingSystem ) && !IsUtfEncoding( keyboardCodingSystem ) )
      ConvertToUNI( istr );
    else if( !IsUtfEncoding( inputCodingSystem ) && IsUtfEncoding( keyboardCodingSystem ) ){
      if( AUTOSELECT == inputCodingSystem )
	inputCodingSystem = defaultCodingSystem;
      ConvertFromUNI( istr, inputCodingSystem );
    }
  } else
#endif /* MSDOS */
    if( BIG_FIVE == inputCodingSystem && BIG_FIVE != keyboardCodingSystem ){
      ConvertCNStoBIG5( istr );
    } else if( BIG_FIVE != inputCodingSystem && BIG_FIVE == keyboardCodingSystem ){
      ConvertBIG5toCNS( istr );
    }
}
