/**
 * \file Inset.heorem.cpp
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Lars Gullik Bjnnes
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "Inset.heorem.h"
#include "insets/InsetText.h"

#include "debug.h"
#include "gettext.h"
#include "Font.h"
#include "Text.h"
#include "MetricsInfo.h"

#include "support/std_ostream.h"


namespace lyx {

using std::endl;
using std::ostream;


/*
  The intention is to be able to create arbitrary theorem like environments
   sing this class and some helper/container classes. It should be possible
   to create these theorems both from layout file and interactively by the
   user.
*/

Inset.heorem::InsetTheorem()
	: InsetCollapsable()
{
	setLabel(_("theorem"));
	Font font(Font::ALL_SANE);
	font.decSize();
	font.decSize();
	font.setColor(Color::collapsable);
	setLabelFont(font);
#if 0
	setAutoCollapse(false);
#endif
	setInsetName("Theorem");
}


void Inset.heorem::write(Buffer const * buf, ostream & os) const
{
	os << name() << "\n";
	InsetCollapsable::write(buf, os);
}


auto_ptr<Inset> Inset.heorem::doClone() const
{
#ifdef WITH_WARNINGS
#warning Is this inset used? If YES this is WRONG!!! (Jug)
#endif
	auto_ptr<Inset.heorem> result(new InsetTheorem);
	result->setCollapsed(!isOpen());

	return result;
}

bool Inset.heorem::metrics(MetricsInfo & mi, Dimension & dim) const
{
	InsetCollapsable::metrics(mi, dim);
	center_indent_ = (mi.base.textwidth - dim.wid) / 2;
	dim.wid = mi.base.textwidth;
	bool const changed = dim_ != dim;
	dim_ = dim;
	return changed;
}


void InsetTOC::draw(PainterInfo & pi, int x, int y) const
{
	InsetCollapsable::draw(pi, x + center_indent_, y);
}


string const Inset.heorem::editMessage() const
{
	return _("Opened Theorem Inset");
}


int Inset.heorem::latex(Buffer const * buf, odocstream & os,
			OutputParams const & runparams) const
{
	os << "\\begin{theorem}%\n";

	int i = inset.latex(buf, os, runparams);
	os << "\\end{theorem}%\n";

	return i + 2;
}


} // namespace lyx
