/**************************************************************************

    begin                : June 30 2004
	version		 : 1.2 
    copyright            : (C) 2004 by Gleb Beliakov
    email                : gleb@deakin.edu.au

  Added in version 1.2 SLipInt class
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at your  *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program; if not, write to the Free Software Foundation, *
 * Inc., 59 Temple Place Suite 330, Boston, MA 02111-1307 USA.             *
 ***************************************************************************/

#include "intwrapper.h"
#include "interpol.h"
#include "slipint.h"

// global variables

// an instance of the interpolant class
STCInterpolant	gl;

// simple Lipschitz interpolant
SLipInt			sli;

// Lipschitz constant (not yet set)
real	GlobalLip=0;

void	SetLipschitz(real x) {GlobalLip=x;}

int	BuildLipInterpolant(int Dim, int Ndata, real* x, real* y)
{
	gl.SetData(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic
	} else
		gl.SetConstants(GlobalLip,Dim+1);  // if it was specified

	gl.Construct();

	return gl.LastError();
//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}

int	BuildLipInterpolantExplicit(int Dim, int Ndata,  real* x, real* y)
{
	gl.SetData(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic, but slow
	} else
		gl.SetConstants(GlobalLip,Dim+1);

	gl.ConstructExplicit();

	return gl.LastError();

//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}

// the methods below are identical to the above, but use columnwise storage of matrices
int	BuildLipInterpolantColumn(int Dim, int Ndata, real* x, real* y)
{
	gl.SetDataColumn(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic
	} else
		gl.SetConstants(GlobalLip,Dim+1);  // if it was specified

	gl.Construct();

	return gl.LastError();
//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}

int	BuildLipInterpolantExplicitColumn(int Dim, int Ndata,  real* x, real* y)
{
	gl.SetDataColumn(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic, but slow
	} else
		gl.SetConstants(GlobalLip,Dim+1);

	gl.ConstructExplicit();

	return gl.LastError();

//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}


 real	InterpolantValue( real* x )
{
	return gl.Value(gl.Dim-1,x); // need to compute the slack variable
}

 real	InterpolantValueExplicit( real* x )
{
	return gl.ValueExplicit(gl.Dim-1,x);
}

/*--------------------------------------------------------*/
/* interface to the members of SLipInt class */
double	SLipIntValue2(int Dim, int Ndata, double* x, double* Xd,double* y,  double Lipconst)
{ return sli.Value2(Dim, Ndata, x, Xd, y, Lipconst); }

double	SLipIntValue2Auto(int Dim, int Ndata, double* Xd,double* x, double* y)
{ return sli.Value2(Dim, Ndata, x, Xd,y); }

double	SLipIntValueInf(int Dim, int Ndata, double* x, double* Xd,double* y, double Lipconst)
{ return sli.ValueInf(Dim, Ndata, x, Xd,y, Lipconst); }

double	SLipIntValueInfArr(int Dim, int Ndata, double* x, double* Xd,double* y, double* Lipconst)
{ return sli.ValueInf(Dim, Ndata, x, Xd,y, Lipconst); }

double	SLipIntValueInfAuto(int Dim, int Ndata, double* x, double* Xd,double* y)
{ return sli.ValueInf(Dim, Ndata, x, Xd, y); }

void		SLipIntComputeLipschitzInf(int Dim, int Ndata, double* x, double* y)
{  sli.ComputeLipschitzInf(Dim, Ndata, x, y); }

void		SLipIntComputeLipschitz2(int Dim, int Ndata, double* x, double* y)
{  sli.ComputeLipschitz2(Dim, Ndata, x, y); }

/* interface to the members of SLipInt class, data in columns */
double	SLipIntValue2Col(int Dim, int Ndata, double* x, double* Xd,double* y,  double Lipconst)
{ return sli.Value2Col(Dim, Ndata, x, Xd, y, Lipconst); }

double	SLipIntValue2AutoCol(int Dim, int Ndata, double* Xd,double* x, double* y)
{ return sli.Value2Col(Dim, Ndata, x, Xd,y); }

double	SLipIntValueInfCol(int Dim, int Ndata, double* x, double* Xd,double* y, double Lipconst)
{ return sli.ValueInfCol(Dim, Ndata, x, Xd,y, Lipconst); }

double	SLipIntValueInfArrCol(int Dim, int Ndata, double* x, double* Xd,double* y, double* Lipconst)
{ return sli.ValueInfCol(Dim, Ndata, x, Xd,y, Lipconst); }

double	SLipIntValueInfAutoCol(int Dim, int Ndata, double* x, double* Xd,double* y)
{ return sli.ValueInfCol(Dim, Ndata, x, Xd, y); }

void		SLipIntComputeLipschitzInfCol(int Dim, int Ndata, double* x, double* y)
{  sli.ComputeLipschitzInfCol(Dim, Ndata, x, y); }

void		SLipIntComputeLipschitz2Col(int Dim, int Ndata, double* x, double* y)
{  sli.ComputeLipschitz2Col(Dim, Ndata, x, y); }
