# vim:noexpandtab:autoindent:tabstop=8:shiftwidth=8:filetype=make:
#-----------------------------------------------------------------------------
#push
sp 				:= $(sp).x
dirstack_$(sp)	:= $(d)
d				:= $(dir)
#-----------------------------------------------------------------------------


testRbu_LIBS := $(d)/../main.o
testRbu_LIBS += $(d)/testRbu.o 
testRbu_LDFLAGS += $(call get_ldflags,smbios) 
testRbu_LDFLAGS += $(call get_ldflags,smbiosxml) 
testRbu_LDFLAGS += $(XMLLIBFLAG)

-include $(patsubst %.o, %.d, $(testRbu_LIBS))

testRbu_LDFLAGS += -Lcppunit/ -lcppunit  -ldl
cppunit/testRbu: $(testRbu_LIBS) $(BASE_LIBS) $(EXT_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING UNIT TEST"
	$(SIL)$(CXX) $($(shell basename $(@:%=%_LIBS))) $($(shell basename $(@:%=%_LIBS_NOD))) $(LDFLAGS) $($(shell basename $(@:%=%_LDFLAGS))) -o $@

cppunit/testRbu-debug: $(testRbu_LIBS:%.o=%.do) $(BASE_STATIC_DEBUG_LIBS) $(EXT_STATIC_DEBUG_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING DEBUG UNIT TEST"
	$(SIL)$(CXX) $(debug_flags) $(testRbu_LIBS:%.o=%.do) $(LDFLAGS) -Lcppunit/ -lcppunit -ldl $(XMLLIBFLAG) $(BASE_STATIC_DEBUG_LIBS) $(EXT_STATIC_DEBUG_LIBS) $(XMLLIBFLAG) -o $@

CLEAN_LIST += cppunit/testRbu cppunit/testRbu-debug

# Pop dir stack back to what it was
d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))
