# vim:noexpandtab:autoindent:tabstop=8:shiftwidth=8:filetype=make:nocindent:

#push
sp 				:= $(sp).x
dirstack_$(sp)	:= $(d)
d				:= $(dir)

#--------------------------------------------
# should automatically pull in all tests...
#--------------------------------------------
testAll_LIBS := $(d)/main.o
testAll_LDFLAGS += $(call get_ldflags,smbios) 
testAll_LDFLAGS += $(call get_ldflags,smbiosxml) 
testAll_LDFLAGS += $(XMLLIBFLAG)

CXXFLAGS += -Icppunit/ 

dir := $(d)/interface
include $(shell ls $(d)/interface/*.mk 2>/dev/null )

-include $(patsubst %.o, %.d, $(testAll_LIBS))

testAll_LDFLAGS += -Lcppunit/ -lcppunit  -ldl
$(d)/testAll: $(testAll_LIBS) $(BASE_LIBS) $(EXT_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING UNIT TEST"
	$(SIL)$(CXX) -o $@ $(expCXXFLAGS) $($(notdir $(@))_LIBS)  $($(shell basename $(@:%=%_LIBS_NOD)))  $(expLDFLAGS)
	#$(SIL)$(CXX) $($(shell basename $(@:%=%_LIBS))) $($(shell basename $(@:%=%_LIBS_NOD))) $(LDFLAGS) $($(shell basename $(@:%=%_LDFLAGS))) -o $@

$(d)/testAll-debug: $(testAll_LIBS:%.o=%.do) $(BASE_STATIC_DEBUG_LIBS) $(EXT_STATIC_DEBUG_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING DEBUG UNIT TEST"
	$(SIL)$(CXX) $(debug_flags) $(testAll_LIBS:%.o=%.do) $(LDFLAGS) -Lcppunit/ -lcppunit -ldl $(XMLLIBFLAG) $(BASE_STATIC_DEBUG_LIBS) $(EXT_STATIC_DEBUG_LIBS) $(XMLLIBFLAG) -o $@

CLEAN_LIST += $(d)/testAll $(d)/testAll-debug

# Pop dir stack back to what it was
d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))
